import { useState, useEffect } from "react";
import { useNavigate, useParams } from "react-router-dom";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import BackButton from "../../../Components/BackButton";
import { productsManagementData } from "../../../Config/data";
import CustomButton from "../../../Components/CustomButton";
import { ImageSliderMultiple } from "../../../Components/ImageSliderMultiple";
import withModal from "../../../HOC/withModal";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faStar } from "@fortawesome/free-solid-svg-icons";
import { ProgressBar } from "react-bootstrap";
import ReviewCard from "../../../Components/ReviewCard";
import { getDetails } from "../../../Services/Api";

const ProductDetails = ({ showModal }) => {
  const { id } = useParams();
  const [productData, setProductData] = useState({});

  useEffect(() => {
    const getProduct = async () => {
      const response = await getDetails(`/admin/product/${id}`);
      if (response.status) {
        setProductData(response.data);
      }
    };
    getProduct();
  }, [id]);

  const {
    name,
    status,
    images,
    description,
    category,
    sku,
    price,
    quantity,
    discounted_price,
    average_rating,
    ratings,
    product_sizes,
    rating_1,
    rating_2,
    rating_3,
    rating_4,
    rating_5,
  } = productData;
  const confirmPopup = (id, status) => {
    showModal(
      `Are you sure you want to ${status == "active" ? "Inactivate" : "Activate"
      } this Product?`,
      () => onConfirm(id, status)
    );
  };
  const navigate = useNavigate();
  const onConfirm = async (id, status) => {
    showModal(
      `Product ${status == "Active" ? "inactivated" : "activated"
      } successfully`, //heading
      null,
      true,
      '/admin/product-management'
    );
    // try {
    //   const response = await post(`/admin-api/users/${id}`);
    //   if (response.status) {
    //     await fetchUsers();
    //     showModal(
    //       `User ${
    //         status === "Active" ? "inactivated" : "activated"
    //       } successfully`, //heading
    //       null, //action
    //       true //sucess
    //     );
    //   }
    // } catch (error) {
    //   console.error("Error updating user status:", error);
    // }
  };
  return (
    <DashboardLayout pageTitle="Product Details">
      <div className="dashCard mb-4">
        <div className="d-flex align-items-center justify-content-between gap-3 flex-wrap">
          <h2 className="mainTitle mb-0 text-uppercase">
            <BackButton />
            Product Details
          </h2>
          <CustomButton text="Edit Product" onClick={() => navigate(`/admin/product-management/edit/${id}`)} />
        </div>
        <div className="statsCard mt-4">
          <h2 className="mainTitle mb-0 text-uppercase">
            {name}
          </h2>
          <div className="mt-4 details-wrapper">
            {[
              { label: "Description", value: description },
              { label: "Status", value: status },
              { label: "Category", value: category?.name },
              { label: "SKU", value: sku },
              { label: "Price", value: "$" + price },
              { label: "Quantity", value: quantity },
              { label: "Size", value: product_sizes?.map(size => size.name).join(", ") },
              { label: "Discounted Price", value: "$" + discounted_price },
            ].map(({ label, value }) => (
              <div className="row mb-3" key={label}>
                <div className="col-12">
                  <h4 className="secondaryLabel">{label}</h4>
                </div>
                <div className="col-12">
                  <p className="secondaryText text-secondary">{value}</p>
                </div>
              </div>
            ))}
          </div>
          <div className="mt-4">
            <h4 className="secondaryLabel">Upload Image</h4>
            <div className="row g-0">
              <div className="col-lg-6">
                {images?.length > 0 && (
                  <img src={images[0]?.path} alt="" className="img-fluid product-details-img-bg" />
                )}
              </div>
              <div className="col-lg-6">
                {images && images.length > 0 && (
                  <div className="image-gallery">
                    {images.slice(1, images.length).map((image, index) => (
                      <img
                        key={index}
                        src={image?.path}
                        alt={`Image ${index + 1}`}
                        className="img-fluid product-details-img-sm"
                      />
                    ))}
                  </div>
                )}
              </div>
            </div>
          </div>
          <div className="mt-4">
            <h2 className="mainTitle mb-0 text-uppercase">Reviews</h2>
            <div className="row">
              <div className="col-lg-4">
                <h2 className="mainTitle mb-0 text-uppercase mt-3">{average_rating}/5({ratings?.length})</h2>
              </div>
              <div className="col-lg-8">
                <div className="d-flex gap-3 mb-3 align-items-center">
                  <div className="flex-shrink-0">
                    <div className="d-flex align-items-center stars-rating justify-content-end">
                      {[5, 4, 3, 2, 1].map((item, index) => (
                        <FontAwesomeIcon icon={faStar} key={index} className="yellowColor" />
                      ))}
                    </div>
                  </div>
                  <div className="flex-grow-1">
                    <ProgressBar now={(rating_5 / ratings?.length) * 100} />
                  </div>
                  <div className="flex-shrink-0">
                    <h4 className="secondaryLabel mb-0">{rating_5}</h4>
                  </div>
                </div>
                <div className="d-flex gap-3 mb-3 align-items-center">
                  <div className="flex-shrink-0">
                    <div className="d-flex align-items-center stars-rating justify-content-end">
                      {[4, 3, 2, 1].map((item, index) => (
                        <FontAwesomeIcon icon={faStar} key={index} className="yellowColor" />
                      ))}
                    </div>
                  </div>
                  <div className="flex-grow-1">
                    <ProgressBar now={(rating_4 / ratings?.length) * 100} />
                  </div>
                  <div className="flex-shrink-0">
                    <h4 className="secondaryLabel mb-0">{rating_4}</h4>
                  </div>
                </div>
                <div className="d-flex gap-3 mb-3 align-items-center">
                  <div className="flex-shrink-0">
                    <div className="d-flex align-items-center stars-rating justify-content-end">
                      {[3, 2, 1].map((item, index) => (
                        <FontAwesomeIcon icon={faStar} key={index} className="yellowColor" />
                      ))}
                    </div>
                  </div>
                  <div className="flex-grow-1">
                    <ProgressBar now={(rating_3 / ratings?.length) * 100} />
                  </div>
                  <div className="flex-shrink-0">
                    <h4 className="secondaryLabel mb-0">{rating_3}</h4>
                  </div>
                </div>
                <div className="d-flex gap-3 mb-3 align-items-center">
                  <div className="flex-shrink-0">
                    <div className="d-flex align-items-center stars-rating justify-content-end">
                      {[2, 1].map((item, index) => (
                        <FontAwesomeIcon icon={faStar} key={index} className="yellowColor" />
                      ))}
                    </div>
                  </div>
                  <div className="flex-grow-1">
                    <ProgressBar now={(rating_2 / ratings?.length) * 100} />
                  </div>
                  <div className="flex-shrink-0">
                    <h4 className="secondaryLabel mb-0">{rating_2}</h4>
                  </div>
                </div>
                <div className="d-flex gap-3 mb-3 align-items-center">
                  <div className="flex-shrink-0">
                    <div className="d-flex align-items-center stars-rating justify-content-end">
                      {[1].map((item, index) => (
                        <FontAwesomeIcon icon={faStar} key={index} className="yellowColor" />
                      ))}
                    </div>
                  </div>
                  <div className="flex-grow-1">
                    <ProgressBar now={(rating_1 / ratings?.length) * 100} />
                  </div>
                  <div className="flex-shrink-0">
                    <h4 className="secondaryLabel mb-0">{rating_1}</h4>
                  </div>
                </div>
              </div>
              {ratings?.map((item, index) => (
                <ReviewCard key={index} {...item} />
              ))}
            </div>
          </div>
        </div>
      </div>
    </DashboardLayout >
  );
};

export default withModal(ProductDetails);
