import { useState } from "react";
import { useNavigate } from "react-router";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import BackButton from "../../../Components/BackButton";
import "./style.css";
import { post } from "../../../Services/Api";
import ChangePasswordForm from "../../../Components/ChangePasswordForm";
import { useFormStatus } from "../../../Hooks/useFormStatus";
import withModal from "../../../HOC/withModal";

const ChangePassword = ({ showModal }) => {
  const navigate = useNavigate();
  const { isSubmitting, startSubmitting, stopSubmitting } = useFormStatus();
  const [errorsData, setErrorsData] = useState({});

  const handleSubmit = async (values) => {
    startSubmitting();
    let response = await post("/admin/change-password", values);
    if (response.status) {
      stopSubmitting();
      showModal(
        `Password changed successfully`,
        null,
        true,
        '/admin/profile'
      );
    }
    stopSubmitting();
  };
  return (
    <>
      <DashboardLayout pageTitle="Change Password">
        <div className="dashCard mb-4">
          <div className="row mb-3">
            <div className="col-md-12">
              <h2 className="mainTitle">
                <BackButton />
                Change Password
              </h2>
            </div>
          </div>
          <div className="row mb-3">
            <div className="col-xl-4 col-lg-4">
              <ChangePasswordForm
                onSubmit={handleSubmit}
                isSubmitting={isSubmitting}
                errors={errorsData}
              />
            </div>
          </div>
        </div>
      </DashboardLayout>
    </>
  );
};

export default withModal(ChangePassword);
