import { useNavigate } from "react-router";
import "./style.css";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import CustomButton from "../../../Components/CustomButton";
import { useAuth } from "../../../Hooks/useAuth";

const Profile = () => {
  const { user } = useAuth();
  const navigate = useNavigate();

  return (
    <>
      <DashboardLayout pageTitle="My Profile">
        <div className="dashCard mb-4">
          <div className="row mb-3">
            <div className="col-12">
              <h2 className="mainTitle">My Profile</h2>
            </div>
          </div>
          <div className="row mb-3">
            {user ? (
              <div className="col-12">
                <div className="row mb-3">
                  <div className="col-lg-12 order-2 order-lg-1 mb-3">
                    <div className="profileImage">
                      <img src={user?.image_url} alt="User" />
                    </div>
                  </div>
                </div>
                <div className="row">
                  <div className="col-lg-8">
                    <div className="row mb-4">
                      <div className="col-lg-12 mb-3">
                        <h4 className="secondaryLabel">First Name</h4>
                        <p className="secondaryText">{user?.first_name}</p>
                      </div>
                      <div className="col-lg-12 mb-3">
                        <h4 className="secondaryLabel">Last Name</h4>
                        <p className="secondaryText">{user?.last_name}</p>
                      </div>
                      <div className="col-lg-12 mb-3">
                        <h4 className="secondaryLabel">Email Address</h4>
                        <p className="secondaryText">{user?.email}</p>
                      </div>
                    </div>
                  </div>
                  <div className="col-md-12 d-flex align-items-center gap-3 flex-wrap">
                    <CustomButton
                      type="button"
                      variant="btnBlueBG"
                      className="px-5"
                      text="Edit Profile"
                      onClick={() => {
                        navigate("/admin/edit-profile");
                      }}
                    />
                    <CustomButton
                      type="button"
                      className="primaryColor"
                      text="Change Password"
                      onClick={() => {
                        navigate("/admin/change-password");
                      }}
                    />
                  </div>
                </div>
              </div>
            ) : (
              ""
            )}
          </div>
        </div>
      </DashboardLayout>
    </>
  );
};

export default Profile;
