import { useState, useEffect } from "react";
import { useParams } from "react-router-dom";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import BackButton from "../../../Components/BackButton";
import { queryManagementData } from "../../../Config/data";
import CustomButton from "../../../Components/CustomButton";
import { ImageSliderMultiple } from "../../../Components/ImageSliderMultiple";
import withModal from "../../../HOC/withModal";
import { dateFormat } from "../../../Utils/helper";
import { getDetails } from "../../../Services/Api";

const QueryDetails = ({ showModal }) => {
  const { id } = useParams();
  const [feedbackData, setFeedbackData] = useState({});

  useEffect(() => {
    const getFeedback = async () => {
      const response = await getDetails(`/admin/feedbacks/${id}`);
      setFeedbackData(response);
      if (response.status) {
        setFeedbackData(response?.data);
      }
    };
    getFeedback();
  }, [id]);

  const {
    first_name,
    last_name,
    email,
    subject,
    message,
    created_at,
  } = feedbackData;
  return (
    <DashboardLayout pageTitle="Query Details">
      <div className="dashCard mb-4">
        <h2 className="mainTitle text-uppercase">
          <BackButton />
          Query Details
        </h2>
        <div className="statsCard mt-4">
          <div className="details-wrapper">
            {[
              { label: "Full Name", value: first_name + " " + last_name },
              { label: "Email", value: email },
              { label: "Subject", value: subject },
              { label: "Date", value: dateFormat(created_at) },
              { label: "Message", value: message },
            ].map(({ label, value }) => (
              <div className="row mb-3" key={label}>
                <div className="col-12">
                  <h4 className="secondaryLabel">{label}</h4>
                </div>
                <div className="col-12">
                  <p className="secondaryText text-secondary">{value}</p>
                </div>
              </div>
            ))}
          </div>
        </div>
      </div>
    </DashboardLayout>
  );
};

export default QueryDetails;
