import { useState, useEffect } from "react";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import CustomTable from "../../../Components/CustomTable";
import { dateFormat, getStatus, serialNum } from "../../../Utils/helper";
import { queryHeaders } from "../../../Config/TableHeaders"; // Table Headers
import { generalStatus, queryType } from "../../../Config/TableStatus"; // Filter Status
import { getAll, post } from "../../../Services/Api"; //Api Service
import TableDropdown from "../../../Components/TableDropdown";
import "./style.css";
import { useFormStatus } from "../../../Hooks/useFormStatus";
import withFilters from "../../../HOC/withFilters ";
import withModal from "../../../HOC/withModal";
import { queryManagementData } from "../../../Config/data";

const QueryManagement = ({
  filters,
  setFilters,
  pagination,
  updatePagination,
}) => {
  const [feedbackData, setFeedbackData] = useState([]);
  const { isSubmitting, startSubmitting, stopSubmitting } = useFormStatus();

  const getFeedback = async () => {
    startSubmitting(true);
    const url = `/admin/feedbacks`;
    const response = await getAll(url, filters);
    if (response.status) {
      const { total, per_page, current_page, to } = response.meta;
      setFeedbackData(response.data);
      updatePagination({
        showData: to,
        currentPage: current_page,
        totalRecords: total,
        totalPages: Math.ceil(total / per_page),
      });
      stopSubmitting(false);
    }
    stopSubmitting(false);
  };

  useEffect(() => {
    getFeedback();
  }, [filters]);

  return (
    <DashboardLayout pageTitle="Query Management">
      <div className="container-fluid">
        <div className="row">
          <div className="col-12">
            <div className="dashCard">
              <div className="row mb-5">
                <div className="col-md-6">
                  <h2 className="mainTitle mb-0">Query Management</h2>
                </div>
              </div>
              <div className="statsCard">
                <div className="row mb-3">
                  <div className="col-12">
                    <CustomTable
                      filters={filters}
                      setFilters={setFilters}
                      loading={isSubmitting}
                      headers={queryHeaders}
                      pagination={pagination}
                      // if you want multiple date filters
                      dateFilters={[
                        {
                          from: "fromDate",
                          to: "toDate",
                        },
                      ]}
                      selectOptions={[
                        {
                          title: "type",
                          options: queryType,
                        },
                      ]}
                    >
                      <tbody>
                        {feedbackData?.map((item, index) => (
                          <tr key={item?.id}>
                            <td>
                              {serialNum(
                                (filters.page - 1) * filters.per_page + index + 1
                              )}
                            </td>
                            <td>{item?.first_name + " " + item?.last_name}</td>
                            <td>{item?.email}</td>
                            <td>{dateFormat(item?.created_at)}</td>
                            <td>{item?.type.toUpperCase()}</td>
                            <td>
                              <TableDropdown
                                view
                                itemId={item?.id}
                                linkPath="/admin/query-management/details"
                                statusDetail={item?.status_detail}
                              />
                            </td>
                          </tr>
                        ))}
                      </tbody>
                    </CustomTable>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </DashboardLayout>
  );
};

export default withFilters(QueryManagement);
// Bind with HOC
// withModal is for Pop Up
// withFilters is for Pagination and default filters
// withPagination, if you want only pagination not filters
// additionalFilters, if you want extra filters on specific pages
