import { useState, useEffect } from "react";
import { useNavigate, useParams } from "react-router-dom";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import BackButton from "../../../Components/BackButton";
import { reportManagementData } from "../../../Config/data";
import CustomButton from "../../../Components/CustomButton";
import { ImageSliderMultiple } from "../../../Components/ImageSliderMultiple";
import withModal from "../../../HOC/withModal";
import { dateFormat } from "../../../Utils/helper";
import { getDetails, post } from "../../../Services/Api";

const ReportDetails = ({ showModal }) => {
  const { id } = useParams();
  const [data, setData] = useState({});
  const getReport = async () => {
    const response = await getDetails(`/admin/report/${id}`);
    if (response.status) {
      setData(response.data);
    }
  };
  useEffect(() => {

    getReport();
  }, [id]);
  const confirmPopup = (id, status) => {
    showModal(
      `Are you sure you want to Mark this Report as Resolved?`,
      () => onConfirm(id, status)
    );
  };
  const navigate = useNavigate();

  const onConfirm = async (id, status) => {

    const response = await post(`/admin/report/${id}/status`);
    if (response.status) {
      await getReport();
      showModal(
        `Issue resolved successfully!`, //heading
        null,
        true,
        '/admin/report-management'
      );
    }

  }
  return (
    <DashboardLayout pageTitle="Report Details">
      <div className="dashCard mb-4">
        <h2 className="mainTitle text-uppercase">
          <BackButton />
          Report Details
        </h2>
        <div className="statsCard mt-4">
          <div className="d-flex flex-lg-nowrap gap-3 flex-wrap-reverse">
            <div className="flex-grow-1">
              <div className="details-wrapper">
                <h2 className="mainTitle mb-4 text-uppercase">User Detail</h2>
                {[
                  { label: "Full Name", value: data?.user?.first_name + " " + data?.user?.last_name },
                  { label: "Email", value: data?.user?.email },
                  { label: "Phone Number", value: data?.user?.phone },
                  { label: "Type", value: data?.type },
                ].map(({ label, value }) => (
                  <div className="row mb-3" key={label}>
                    <div className="col-12">
                      <h4 className="secondaryLabel">{label}</h4>
                    </div>
                    <div className="col-12">
                      <p className="secondaryText text-secondary">{value}</p>
                    </div>
                  </div>
                ))}
                <h2 className="mainTitle my-4 text-uppercase">report</h2>
                <div>
                  <h4 className="secondaryLabel">Reason</h4>
                  <p className="secondaryText text-secondary">{data?.reason}</p>
                </div>
                <div className="mt-4">
                  {data?.status == 'pending' ? (
                    <CustomButton onClick={() => navigate(data?.type == 'User' ? `/admin/user-management/${data?.reportable?.id}` : `/admin/order-management/details/${data?.reportable?.id}`)} text={`View ${data?.type == "User" ? 'User' : 'Order'}`} className="mt-3" />
                  ) : ''}
                </div>
              </div>
            </div>
            <div className="flex-shrink-0 user-details-card text-end">
              <div className="d-flex align-items-center justify-content-end gap-2">
                <label className="semi-bold">Status</label>
                <span
                  className={`semi-bold ${data?.status === 'pending' ? "primaryColor" : "greenColor"
                    }`}
                >
                  {data?.status}
                </span>
              </div>
              {data?.status == 'pending' ? (
                <CustomButton onClick={() => confirmPopup(data?.id, data?.status)} text={"Mark As Resolved"} className="mt-3" />
              ) : ''}
            </div>
          </div>
        </div>
      </div>
    </DashboardLayout>
  );
};

export default withModal(ReportDetails);
