import { useState, useEffect } from "react";
import { useNavigate, useParams } from "react-router-dom";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import BackButton from "../../../Components/BackButton";
import { orderManagementData, userManagementData } from "../../../Config/data";
import CustomButton from "../../../Components/CustomButton";
import { ImageSliderMultiple } from "../../../Components/ImageSliderMultiple";
import withModal from "../../../HOC/withModal";
import withFilters from "../../../HOC/withFilters ";
import CustomTable from "../../../Components/CustomTable";
import { dateFormat, serialNum } from "../../../Utils/helper";
import TableDropdown from "../../../Components/TableDropdown";
import { orderHeaders } from "../../../Config/TableHeaders";
import { useFormStatus } from "../../../Hooks/useFormStatus";
import { deliveryStatus, generalStatus } from "../../../Config/TableStatus";
import { images } from "../../../Assets";
import { getAll, getDetails, post } from "../../../Services/Api";
import IntlTelInput from "react-intl-tel-input";
import 'react-intl-tel-input/dist/main.css';
import ImageGallery from "../../../Components/ImageGallery/ImageGallery";
const UserDetails = ({ showModal, filters,
  setFilters,
  pagination,
  updatePagination, }) => {
  const { id } = useParams();
  const [profileData, setProfileData] = useState({});
  const [data, setData] = useState({});
  const [orderData, setOrderData] = useState([]);
  const { isSubmitting, startSubmitting, stopSubmitting } = useFormStatus();
  const fetchOrders = async () => {
    startSubmitting(true);
    const url = `/admin/order/orders/${id}`;
    const response = await getAll(url, filters);
    if (response.status) {
      const { total, per_page, current_page, to } = response.meta;
      setOrderData(response.data);
      updatePagination({
        showData: to,
        currentPage: current_page,
        totalRecords: total,
        totalPages: Math.ceil(total / per_page),
      });
      stopSubmitting(false);
    }
  };
  const getUser = async () => {
    const response = userManagementData.detail.data.find(e => e.id == 17);
    setProfileData(response);
    let userOrderData = orderManagementData.detail.data.filter(e => e.user_id == 17)
    setOrderData(userOrderData);
    const apiResponse = await getDetails(`/admin/user/${id}`);
    if (apiResponse.status) {
      console.log("api response", apiResponse);

      setData(apiResponse.data);
    }
  };
  useEffect(() => {
    getUser();
  }, [id]);
  useEffect(() => {
    fetchOrders();
  }, [id, filters]);

  const {
    name,
    age,
    about,
    interests,
    exercise,
    education,
    drinking,
    smoking,
    children,
    star,
    politics,
    user_images,
    email,
    phone_number,
    status,
    status_detail,
    ring
  } = profileData;

  const confirmPopup = (id, status) => {
    showModal(
      `Are you sure you want to ${status === 1 ? "Inactivate" : "Activate"
      } this User?`,
      () => onConfirm(id, status)
    );
  };
  const confirmPopupVerification = (id, is_verified) => {
    showModal(
      `Are you sure you want to ${is_verified === 0 ? "Verify" : "Un-Verify"
      } this User?`,
      () => onConfirmVification(id, status)
    );
  };
  const onConfirm = async (id, status) => {
    const response = await post(`/admin/user/${id}/status`);
    if (response.status) {
      showModal(
        `User ${response?.data?.status === 0 ? "inactivated" : "activated"
        } successfully`, //heading
        null, //action
        true, //sucess,
        '/admin/user-management'
      );
    }
  };
  const onConfirmVification = async (id, is_verified) => {
    const response = await post(`/admin/user/${id}/verificationStatus`);
    if (response.status) {
      showModal(
        `User ${response?.data?.is_verified === 0 ? "un verified" : "verified"
        } successfully`, //heading
        null, //action
        true, //sucess,
        '/admin/user-management'
      );
    }
  };
  return (
    <DashboardLayout pageTitle="User Details">
      <div className="dashCard mb-4">
        <h2 className="mainTitle text-uppercase">
          <BackButton />
          User Details
        </h2>
        <div className="statsCard mt-4">
          <div className="d-flex gap-3 flex-lg-nowrap flex-wrap-reverse justify-content-between mb-3">
            <div className="flex-grow-1">
              <h3 className="mainTitle text-uppercase">User Profile Details</h3>
              {data?.verification_images?.length > 0 && (
                < >
                  <div className="mt-5">
                    <ImageGallery images={data?.verification_images?.map(image => image.path)} width="300px" maxWidth="50%" borderRadius={8} />
                    <div className="d-flex align-items-center justify-content-start gap-2">
                      <label className="semi-bold">Verification Status : </label>
                      <span
                        className={`semi-bold ${data?.is_verified == 0 ? "redColor" : "greenColor"
                          }`}
                      >
                        {data?.is_verified === 1 ? "verified" : "Not verified"}
                      </span>
                    </div>
                    <CustomButton onClick={() => confirmPopupVerification(data?.id, data?.is_verified)} text={data?.is_verified === 1 ? "Mark As Unverify" : "Mark As Verify"} className="mt-3" />
                  </div>
                </>
              )}
              <div className="mt-4">
                {[
                  { label: "Full Name", value: data?.full_name },
                  { label: "Age", value: data?.age },
                  { label: "Email", value: data?.email },
                  { label: "About Yourself", value: data?.about },
                ].map(({ label, value }) => (
                  <div className="row mb-3" key={label}>
                    <div className="col-12">
                      <h4 className="secondaryLabel">{label}</h4>
                    </div>
                    <div className="col-12">
                      <p className="secondaryText text-secondary">{value}</p>
                    </div>
                  </div>
                ))}

                {/* Phone Number Field with IntlTelInput */}
                <div className="row mb-3">
                  <div className="col-12">
                    <h4 className="secondaryLabel">Phone Number</h4>
                  </div>
                  <div className="col-12">
                    <IntlTelInput
                      disabled={true}
                      containerClassName="intl-tel-input"
                      inputClassName="border-0"
                      defaultCountry={data?.country_code ? data.country_code.toLowerCase() : "us"} // Fallback to "us" if undefined
                      value={`${data?.dial_code}${data?.phone}`} // Combine dialing code and number
                      separateDialCode={false}
                      preferredCountries={[data?.country_code ? data.country_code.toLowerCase() : "us"]}
                    />
                  </div>
                </div>
                {/* {console.log("testing", data?.preferences[0].answers[0]?.option_text)} */}

                {data?.preferences?.map((field, index) => (
                  <div className="col-md-4 col-sm-6 col-12 my-3" key={index}>
                    {/* <label className="gilroy bold mb-0">{field.question_text}</label> */}
                    <div className="col-12">
                      <h4 className="secondaryLabel">{field.question_text}</h4>
                    </div>
                    {field?.answers?.map((answer, index) => (
                      <div key={index}>
                        <p className="secondaryText text-secondary">{answer.option_text}</p>
                      </div>
                    ))}

                  </div>
                ))}
                {data?.user_answers?.map((field, index) => (
                  <div className="row mb-3" key={index}>
                    <div className="col-12">
                      <h4 className="secondaryLabel">Q : {field?.question?.question_text}</h4>
                    </div>
                    <div className="col-12">
                      <p className="secondaryText text-secondary">{field?.answer}</p>
                    </div>
                  </div>
                ))}
              </div>
            </div>
            <div className="flex-shrink-0 user-details-card text-end">
              <div className="d-flex align-items-center justify-content-end gap-2">
                <label className="semi-bold">Status</label>
                <span
                  className={`semi-bold ${data?.status === 0 ? "redColor" : "greenColor"
                    }`}
                >
                  {data?.status === 1 ? "Active" : "In Active"}
                </span>
              </div>
              <CustomButton onClick={() => confirmPopup(data?.id, data?.status)} text={data?.status === 1 ? "Mark As In Active" : "Mark As Active"} className="mt-3" />
              <div className="mt-5">
                <ImageSliderMultiple images={data?.images} />
              </div>
            </div>
          </div>
          <div className="mt-4">
            <h2 className="mainTitle text-uppercase">Orders</h2>
            <CustomTable
              filters={filters}
              setFilters={setFilters}
              loading={isSubmitting}
              headers={orderHeaders}
              pagination={pagination}
              // if you want multiple date filters
              dateFilters={[
                {
                  from: "fromDate",
                  to: "toDate",
                },
              ]}
              // if you want multiple select filters
              selectOptions={[
                {
                  title: "status",
                  options: deliveryStatus,
                },
              ]}
            >
              <tbody>
                {orderData?.map((item, index) => (
                  <tr key={item?.id}>
                    <td>
                      {serialNum(
                        (filters.page - 1) * filters.per_page + index + 1
                      )}
                    </td>
                    <td>#{item?.id}</td>
                    <td>{item?.user?.full_name}</td>
                    <td>{dateFormat(item?.created_at)}</td>
                    <td>${item?.total_price}</td>
                    <td>{item?.status}</td>
                    <td>
                      <TableDropdown
                        view
                        itemId={item?.id}
                        linkPath="/admin/order-management/details"
                      />
                    </td>
                  </tr>
                ))}
              </tbody>
            </CustomTable>
          </div>
        </div>
      </div>
    </DashboardLayout>
  );
};
//Additional Filters
const additionalFilters = {
  type: "",
  expiryFromDate: "",
  expiryToDate: "",
};
export default withModal(withFilters(UserDetails));
