import { useState } from "react";
import "./style.css";
import CustomModal from "../../../Components/CustomModal";
import { post } from "../../../Services/Api";
import ContactForm from "../../../Components/ContactForm";
import { UserLayout } from "../../../Components/user/Layout";
import { Formik } from "formik";
import CustomInput from "../../../Components/CustomInput";
import { registerValidationSchema } from "../../../Config/Validations";
import CustomButton from "../../../Components/CustomButton";
import IntlTelInput from 'react-intl-tel-input';
import 'react-intl-tel-input/dist/main.css';
import { Form } from "react-bootstrap";
import { Link, useNavigate } from "react-router-dom";
import { genderStatus } from "../../../Config/TableStatus";
import { FormSelect } from "../../../Components/Select/FormSelect";

const Register = () => {
  const navigate = useNavigate();
  const [showModal, setShowModal] = useState(false);
  const handleClose = () => {
    setShowModal(false);
    navigate('/login')
  }
  const handleSubmit = async (values, { resetForm }) => {
    let response = await post("/user/signup", values);
    if (response.status) {
      resetForm();
      setShowModal(true);

    }
  };

  return (
    <>
      <UserLayout pageTitle="Register">
        <section className="contact-us py-sm-5 py-4">
          <div className="container">
            <div className="row">
              <div className="col-12">
                <div className="contact-card">
                  <div className="contact-card-inner">
                    <h4 className="heavy mb-4 text-center">Register</h4>
                    <Formik
                      initialValues={{
                        first_name: "",
                        last_name: "",
                        email: "",
                        phone: "",
                        dial_code: "",
                        country_code: "",
                        gender: "",
                        age: "",
                        date_of_birth: "",
                        about: "",
                        password: "",
                        password_confirmation: "",
                      }}
                      validationSchema={registerValidationSchema}
                      onSubmit={handleSubmit}
                    >
                      {({
                        values,
                        errors,
                        touched,
                        handleChange,
                        handleBlur,
                        setFieldValue,
                        handleSubmit,
                      }) => (
                        <Form onSubmit={handleSubmit}>
                          <div className="row">
                            <div className="col-md-6">
                              <CustomInput
                                label="First Name"
                                labelclass="mainLabel"
                                type="text"
                                placeholder="Enter First Name"
                                inputclass="mainInput"
                                id="first_name"
                                requiredStar
                                value={values.first_name}
                                onChange={handleChange}
                                onBlur={handleBlur}
                                error={touched.first_name && errors.first_name}
                              />
                            </div>
                            <div className="col-md-6">
                              <CustomInput
                                label="Last Name"
                                labelclass="mainLabel"
                                type="text"
                                placeholder="Enter Last Name"
                                inputclass="mainInput"
                                id="last_name"
                                requiredStar
                                value={values.last_name}
                                onChange={handleChange}
                                onBlur={handleBlur}
                                error={touched.last_name && errors.last_name}
                              />
                            </div>
                          </div>
                          <CustomInput
                            label="Email Address"
                            labelclass="mainLabel"
                            type="email"
                            placeholder="Enter Email Address"
                            inputclass="mainInput"
                            id="email"
                            requiredStar
                            value={values.email}
                            onChange={handleChange}
                            onBlur={handleBlur}
                            error={touched.email && errors.email}
                          />
                          <label htmlFor="" className="mainLabel">Phone Number<span className="redColor">*</span></label>
                          <IntlTelInput
                            containerClassName="intl-tel-input w-100 mb-3"
                            inputClassName="mainInput"
                            placeholder="Enter Phone Number"
                            value={values.phone}
                            onChangeNumber={true}
                            // onChangeValidity={true}
                            onPhoneNumberChange={(isValid,
                              value,
                              selectedCountryData,
                              fullNumber,) => {
                              console.log("isValid", isValid);
                              console.log("value", value);
                              console.log("selectedCountryData", selectedCountryData);

                              setFieldValue('phone', fullNumber);
                              setFieldValue('dial_code', selectedCountryData?.dialCode);
                              setFieldValue('country_code', selectedCountryData?.iso2?.toUpperCase());
                            }}
                            onBlur={() => handleBlur({ target: { name: 'phone' } })} // Mark as touched
                            preferredCountries={['us', 'ca']} // Set preferred countries if needed
                          />
                          {touched?.phone && errors?.phone && (
                            <div className="error-message">{errors.phone}</div>
                          )}
                          <label htmlFor="" className="mainLabel">Gender<span className="redColor">*</span></label>
                          <FormSelect
                            name="gender"
                            value={values.gender}
                            onChange={handleChange}
                            onBlur={handleBlur}
                            options={genderStatus}
                            className="mainInput"
                          />
                          {/* {genderStatus.map(option => (
                              <option key={option.value} value={option.value}>
                                {option.label}
                              </option>
                            ))}
                          </FormSelect> */}
                          {/* {touched?.gender && errors?.gender && (
                            <div className="error-message">{errors.gender}</div>
                          )} */}
                          <div className="row mt-3">
                            <div className="col-md-6">
                              <CustomInput
                                label="Age"
                                labelclass="mainLabel"
                                type="number"
                                placeholder="Enter Age"
                                inputclass="mainInput"
                                id="age"
                                requiredStar
                                value={values.age}
                                onChange={handleChange}
                                onBlur={handleBlur}
                                error={touched.age && errors.age}
                              />
                            </div>
                            <div className="col-md-6">
                              <CustomInput
                                label="Date of Birth"
                                labelclass="mainLabel"
                                type="date"
                                placeholder="Enter Date of Birth"
                                inputclass="mainInput"
                                id="date_of_birth"
                                requiredStar
                                value={values.date_of_birth}
                                onChange={handleChange}
                                onBlur={handleBlur}
                                error={touched.date_of_birth && errors.date_of_birth}
                              />
                            </div>
                          </div>

                          <CustomInput
                            label="Bio"
                            labelclass="mainLabel"
                            type="text"
                            placeholder="Enter Bio"
                            inputclass="mainInput"
                            id="about"
                            requiredStar
                            value={values.about}
                            onChange={handleChange}
                            onBlur={handleBlur}
                            error={touched.about && errors.about}
                          />
                          <CustomInput
                            label="Password"
                            id="password"
                            type="password"
                            placeholder="Enter Password"
                            labelclass="mainLabel"
                            inputclass="mainInput mainInputLogIn"
                            value={values.password}
                            onChange={handleChange}
                            onBlur={handleBlur}
                            error={touched.password && errors.password}
                          />

                          <CustomInput
                            label="Confirm Password"
                            id="password_confirmation"
                            type="password"
                            placeholder="Confirm Password"
                            labelclass="mainLabel"
                            inputclass="mainInput mainInputLogIn"
                            value={values.password_confirmation}
                            onChange={handleChange}
                            onBlur={handleBlur}
                            error={
                              touched.password_confirmation && errors.password_confirmation
                            }
                          />
                          <div className="text-center mt-4">
                            <CustomButton
                              className="btnBlueBG px-5"
                              text="Register"
                              type="submit"
                            />
                          </div>
                          <div className="d-flex align-items-center justify-content-center mt-3 gap-1">
                            <p className="mb-0">Already have an account?</p>
                            <Link to={'/login'} className="secondaryColor">Login</Link>
                          </div>
                        </Form>
                      )}
                    </Formik>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>

        <CustomModal
          show={showModal}
          close={handleClose}
          success
          heading="Account Created Sucessfully"
        />
      </UserLayout>
    </>
  );
};
export default Register;
