import { useState } from "react";
import "./style.css";
import CustomModal from "../../../Components/CustomModal";
import { post } from "../../../Services/Api";
import ContactForm from "../../../Components/ContactForm";
import { UserLayout } from "../../../Components/user/Layout";
import { Formik } from "formik";
import CustomInput from "../../../Components/CustomInput";
import CustomButton from "../../../Components/CustomButton";
import BackButton from "../../../Components/BackButton";
import { useNavigate } from "react-router-dom";

const BankDetails = () => {
  const [showModal, setShowModal] = useState(false);
  const submitNow = (e) => {
    e.preventDefault();
    setShowModal(true);
  };
  const navigate = useNavigate();

  return (
    <>
      <UserLayout pageTitle="Bank Details">
        <section className="contact-us py-sm-5 py-4">
          <div className="container">
            <div className="row">
              <div className="col-12">
                <div className="contact-card">
                  <div className="contact-card-inner">
                    <div className="d-flex align-items-center gap-2 mb-4">
                      <BackButton />
                      <h4 className="heavy mb-0">Bank Details</h4>
                    </div>
                    <Formik
                      initialValues={{
                        name: "",
                        cardNumber: "",
                        date: "",
                        cvv: "",
                      }}
                      validationSchema={''}
                      onSubmit={submitNow}
                    >
                      {({
                        values,
                        errors,
                        touched,
                        handleChange,
                        handleBlur,
                        handleSubmit,
                      }) => (
                        <form onSubmit={submitNow}>
                          <div className="col-md-12">
                            <CustomInput
                              label="Cardholder Name"
                              labelclass="mainLabel"
                              type="text"
                              placeholder="Enter Cardholder Name"
                              inputclass="mainInput"
                              id="name"
                              required
                              value={values.name}
                              onChange={handleChange}
                              onBlur={handleBlur}
                              error={touched.name && errors.name}
                            />
                            <CustomInput
                              label="Card Number"
                              labelclass="mainLabel"
                              type="number"
                              placeholder="Enter Card Number"
                              inputclass="mainInput"
                              id="cardNumber"
                              required
                              value={values.cardNumber}
                              onChange={handleChange}
                              onBlur={handleBlur}
                              error={touched.cardNumber && errors.cardNumber}
                            />
                            <CustomInput
                              label="Validity Date"
                              labelclass="mainLabel"
                              type="month"
                              placeholder="Enter Validity Date"
                              inputclass="mainInput"
                              id="date"
                              required
                              value={values.date}
                              onChange={handleChange}
                              onBlur={handleBlur}
                              error={touched.date && errors.date}
                            />
                            <CustomInput
                              label="CVV"
                              labelclass="mainLabel"
                              type="number"
                              placeholder="Enter CVV"
                              inputclass="mainInput"
                              id="cvv"
                              required
                              value={values.cvv}
                              onChange={handleChange}
                              onBlur={handleBlur}
                              error={touched.cvv && errors.cvv}
                            />
                            <div className="text-center mt-4">
                              <CustomButton
                                className="btnBlueBG px-5"
                                text="Submit"
                                type="submit"
                              />
                            </div>
                          </div>
                        </form>
                      )}
                    </Formik>

                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>

        <CustomModal
          show={showModal}
          close={() => {
            setShowModal(false)
            navigate('/my-orders')
          }}
          success
          heading="Order has been placed successfully"
        />
      </UserLayout>
    </>
  );
};
export default BankDetails;
