import React, { useEffect, useState } from 'react';
import { UserLayout } from '../../../Components/user/Layout';
import { cartHeaders } from '../../../Config/TableHeaders';
import CustomTable from '../../../Components/CustomTable';
import './index.css'
import SiteInput from '../../../Components/Input/input';
import CustomInput from '../../../Components/CustomInput';
import CustomButton from '../../../Components/CustomButton';
import QuantityInput from '../../../Components/user/QuantityInput/QuantityInput';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faTimes } from '@fortawesome/free-solid-svg-icons';
import { useNavigate } from 'react-router-dom';
import { deleteData, getAll, post } from '../../../Services/Api';
import { useDispatch } from 'react-redux';
import { removeFromCart } from '../../../Store/actions/cartActions';
import LoadingSpinner from '../../../Components/Loader';
import { useAuth } from '../../../Hooks/useAuth';
import CustomModal from '../../../Components/CustomModal';

const MyCart = () => {
    const { sessionId, user } = useAuth();
    const [showModal, setShowModal] = useState(false);
    const [loading, setLoading] = useState([])
    const [deliveryCharges, setDeliveryCharges] = useState({})
    const dispatch = useDispatch();
    const [data, setData] = useState([])
    const fetchData = async () => {
        let user_id;
        if (!user) {
            user_id = sessionId.sessionId;
            // If user is not logged in, redirect to the login page
            // navigate("/login");
            // return;
        } else {
            user_id = user.id;
        }
        setLoading(true);
        const response = await getAll(`/user/cart/items?user_id=${user_id}`);
        console.log("api response", response);

        if (response.status) {
            setData(response.data);
        }
        setLoading(false);
    };
    const fetchDeliveryCharges = async () => {
        setLoading(true);
        const response = await getAll(`/user/deliveryCharge/deliveryCharges`);

        if (response.status) {
            setDeliveryCharges(response.data);
        }
        setLoading(false);
    };
    useEffect(() => {
        fetchData();
        fetchDeliveryCharges()
    }, []);
    const handleQuantityChange = async (newQuantity, cartId, productId) => {
        console.log(cartId);

        setLoading(true);
        const response = await post(`/user/cart/change-quantity/${cartId}`, { "quantity": newQuantity, "product_id": productId });
        if (response.status) {
            const indexToUpdate = data.findIndex(item => item.id === response?.data?.id);
            // Update the item if it exists
            if (indexToUpdate !== -1) {
                data[indexToUpdate] = response?.data;
            }
        }
        dispatch(removeFromCart(productId));
        setLoading(false);
    };
    const calculateTotalPrice = (cartItems) => {
        return cartItems.reduce((total, item) => {
            return total + item.total; // Use item.total to get the total price for each item
        }, 0);
    };

    const handleRemoveFromCart = async (id, productId) => {
        console.log("product", id);
        let response = await deleteData(`user/cart/remove/${id}`); // Make sure this works with your backend API
        if (response.status) {
            setShowModal(true);
            console.log("inside success", productId);
            dispatch(removeFromCart({ productId }));
            fetchData();
        }
    };
    const navigate = useNavigate();
    return (
        <>
            <UserLayout>
                <section className="my-cart py-sm-5 py-4">
                    <div className="container">
                        <div className="row">
                            <div className="col-12">
                                <div className="contact-card ps-lg-5 mxw-100">
                                    <h4 className="heavy">My Cart</h4>
                                    <div className="row">
                                        <div className="col-lg-8">
                                            <CustomTable
                                                noFilters
                                                headers={cartHeaders}
                                            >
                                                {loading ? (
                                                    <LoadingSpinner rollerStyle={{ left: "100%", transform: 'translateX(100%)' }} />

                                                ) : data.length > 0 ? (
                                                    <tbody className={`${loading ? '' : 'text-center'}`}>
                                                        {data?.map((item, index) => (
                                                            <tr key={item?.id}>
                                                                <td>{index < 10 ? `0${index + 1}` : index}</td>
                                                                <td>
                                                                    <div className="d-flex align-items-center gap-2">
                                                                        <div className="flex-shrink-0">
                                                                            <img src={item?.product?.images[0]?.path} alt="" className="img-fluid category-img-sm" />
                                                                        </div>
                                                                        <div className="flex-grow-1">
                                                                            <p className="mb-0">{item?.product?.name}</p>
                                                                            <p className="mb-0 mt-1">{item?.product?.category?.name}</p>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td>${item?.price}</td>
                                                                <td>
                                                                    <QuantityInput
                                                                        min={1}
                                                                        max={10}
                                                                        step={1}
                                                                        initialQuantity={item?.quantity}
                                                                        onChange={(newQuantity) => handleQuantityChange(newQuantity, item?.id, item?.product?.id)}
                                                                    />
                                                                </td>
                                                                <td>{item?.size?.name ? item?.size?.name : "-"}</td>
                                                                <td>${item?.total}</td>
                                                                <td>
                                                                    <button className="transparent-btn" onClick={() => handleRemoveFromCart(item?.id, item?.product?.id)}>
                                                                        <FontAwesomeIcon icon={faTimes} className='redColor' />
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                        ))}
                                                    </tbody>
                                                ) : (
                                                    <div>
                                                        <p>Data not found</p>
                                                    </div>
                                                )}


                                            </CustomTable>
                                        </div>
                                        <div className="col-lg-4">
                                            <div className="summary-card">
                                                <p className="p-md mb-0 gilroy bold">Order Summary</p>
                                                <div className="d-flex mt-3 justify-content-between align-items-center">
                                                    <p className="mb-0">Sub Total</p>
                                                    <p className="mb-0">${calculateTotalPrice(data)}</p>
                                                </div>
                                                <div className="d-flex mt-3 justify-content-between align-items-center">
                                                    <p className="mb-0">Delivery Charges</p>
                                                    <p className="mb-0">${deliveryCharges?.amount}</p>
                                                </div>
                                                <hr />
                                                <div className="d-flex mt-3 justify-content-between align-items-center">
                                                    <p className="mb-0">Total</p>
                                                    <p className="mb-0">${calculateTotalPrice(data) + deliveryCharges?.amount}</p>
                                                </div>
                                                <div className="mt-3">
                                                    <CustomInput type="textarea" rows="7" placeholder="Any special instruction for seller" inputclass="mainInput" label="Additional Information" />
                                                </div>
                                                <div className="mt-4">
                                                    <CustomButton isPending={data?.length > 0 ? false : true} onClick={() => navigate('/checkout')} className="w-100" text="Proceed to checkout" />
                                                    <CustomButton onClick={() => navigate('/categories')} className="w-100 mt-3 yellow-btn" text="Continue Shopping" />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </UserLayout>
            <CustomModal
                show={showModal}
                close={() => setShowModal(false)}
                success
                heading="Product Has been removed from cart"
                para=""
            />
        </>

    );
}

export default MyCart;
