import React, { useEffect, useState } from 'react';
import { UserLayout } from '../../../Components/user/Layout';
import { checkoutCartHeaders } from '../../../Config/TableHeaders';
import { myCart } from '../../../Config/userData';
import CustomTable from '../../../Components/CustomTable';
import './index.css'
import CustomInput from '../../../Components/CustomInput';
import CustomButton from '../../../Components/CustomButton';
import { useNavigate } from 'react-router-dom';
import BackButton from '../../../Components/BackButton';
import { Formik } from 'formik';
import CustomModal from '../../../Components/CustomModal';
import IntlTelInput from 'react-intl-tel-input';
import 'react-intl-tel-input/dist/main.css';
import { Form } from 'react-bootstrap';
import { ShippingValidationSchema } from '../../../Config/Validations';
import { getAll, orderPost, post } from '../../../Services/Api';
import { useDispatch } from 'react-redux';
import { clearCart } from '../../../Store/actions/cartActions';
import LoadingSpinner from '../../../Components/Loader';
import { useAuth } from '../../../Hooks/useAuth';

const Checkout = () => {
    const { sessionId, user } = useAuth();

    const [data, setData] = useState([]);
    const [formData, setFromData] = useState({});
    const dispatch = useDispatch();

    useEffect(() => {
        setData(myCart)
    }, []);
    const handleQuantityChange = (newQuantity) => {
        console.log("New Quantity:", newQuantity);
    };
    const navigate = useNavigate();
    const [showModal, setShowModal] = useState(false);
    const [showModalSuccess, setShowModalSuccess] = useState(false);
    const [loading, setLoading] = useState([])
    const [deliveryCharges, setDeliveryCharges] = useState({})

    const handleSubmit = async (values, { setSubmitting, resetForm, setErrors }) => {

        const errors = {};

        // Check for required billing address fields if using a different billing address
        if (values.useDifferentBillingAddress) {
            if (!values.billingAddress.first_name) {
                errors.billingAddress = {
                    ...errors.billingAddress,
                    first_name: "First name is required",
                };
            }
            if (!values.billingAddress.last_name) {
                errors.billingAddress = {
                    ...errors.billingAddress,
                    last_name: "Last name is required",
                };
            }
            if (!values.billingAddress.address) {
                errors.billingAddress = {
                    ...errors.billingAddress,
                    address: "Address is required",
                };
            }
            if (!values.billingAddress.phone) {
                errors.billingAddress = {
                    ...errors.billingAddress,
                    phone: "Phone number is required",
                };
            }
            if (!values.billingAddress.country) {
                errors.billingAddress = {
                    ...errors.billingAddress,
                    country: "Country is required",
                };
            }
            if (!values.billingAddress.state) {
                errors.billingAddress = {
                    ...errors.billingAddress,
                    state: "State is required",
                };
            }
            if (!values.billingAddress.city) {
                errors.billingAddress = {
                    ...errors.billingAddress,
                    city: "City is required",
                };
            }
            if (!values.billingAddress.zip_code) {
                errors.billingAddress = {
                    ...errors.billingAddress,
                    zip_code: "Zip Code is required",
                };
            }
        }

        // If there are errors, set them and prevent form submission
        if (Object.keys(errors).length > 0) {
            setErrors(errors);
            setSubmitting(false); // Reset submitting state
            return; // Prevent submission
        }
        console.log("Submitting values:", values);
        setFromData(values);
        setSubmitting(false);
        setShowModal(true);
    };
    const fetchData = async () => {
        let user_id;
        if (!user) {
            user_id = sessionId.sessionId;
            // If user is not logged in, redirect to the login page
            // navigate("/login");
            // return;
        } else {
            user_id = user.id;
        }
        setLoading(true);
        const response = await getAll(`/user/cart/items?user_id=${user_id}`);
        if (response.status) {
            setData(response.data);
        }
        setLoading(false);
    };
    const fetchDeliveryCharges = async () => {
        setLoading(true);
        const response = await getAll(`/user/deliveryCharge/deliveryCharges`);
        if (response.status) {
            setDeliveryCharges(response.data);
        }
        setLoading(false);
    };
    useEffect(() => {
        fetchData();
        fetchDeliveryCharges()
    }, []);
    const calculateTotalPrice = (cartItems) => {
        return cartItems.reduce((total, item) => {
            return total + item.total; // Use item.total to get the total price for each item
        }, 0);
    };
    const createOrder = async () => {
        if (!formData.useDifferentBillingAddress) {
            formData.billingAddress = formData.shippingAddress;
        }
        let user_id;
        if (!user) {
            user_id = sessionId.sessionId;
            // If user is not logged in, redirect to the login page
            // navigate("/login");
            // return;
        } else {
            user_id = user.id;
        }
        console.log("form data", formData);

        let response = await orderPost(`/user/order/add?user_id=${user_id}`, formData);
        console.log(response);

        if (response.status) {
            window.location.href = response.data.url;
            dispatch(clearCart());
            setShowModal(false);
            // setShowModalSuccess(true);
        }
    };
    return (
        <>
            <UserLayout>
                <section className="my-cart py-sm-5 py-4">
                    <div className="container">
                        <div className="row">
                            <div className="col-12">
                                <div className="contact-card ps-lg-5 mxw-100">
                                    <div className="d-flex align-items-center gap-3">
                                        <BackButton />
                                        <h4 className="heavy mb-0">Checkout</h4>
                                    </div>
                                    <div className="row">
                                        <div className="col-lg-7">
                                            <Formik
                                                initialValues={{
                                                    contactInfo: {
                                                        first_name: '',
                                                        last_name: '',
                                                        email: '',
                                                        phone: '',
                                                        dial_code: '',
                                                        country_code: '',
                                                    },
                                                    shippingAddress: {
                                                        first_name: '',
                                                        last_name: '',
                                                        address: '',
                                                        phone: '',
                                                        dial_code: '',
                                                        country_code: '',
                                                        country: '',
                                                        state: '',
                                                        city: '',
                                                        zip_code: '',
                                                    },
                                                    billingAddress: {
                                                        first_name: '',
                                                        last_name: '',
                                                        address: '',
                                                        phone: '',
                                                        dial_code: '',
                                                        country_code: '',
                                                        country: '',
                                                        state: '',
                                                        city: '',
                                                        zip_code: '',
                                                    },
                                                    useDifferentBillingAddress: false, // This must be in the form values
                                                }}
                                                validationSchema={ShippingValidationSchema}
                                                onSubmit={handleSubmit}
                                                validateOnChange={true}
                                                validateOnBlur={true}
                                            >
                                                {({
                                                    values,
                                                    errors,
                                                    touched,
                                                    handleChange,
                                                    handleBlur,
                                                    handleSubmit,
                                                    setFieldValue,
                                                    isSubmitting,
                                                }) => {
                                                    return (
                                                        < form onSubmit={handleSubmit}>
                                                            <div className="col-md-12">
                                                                <p className="bold p-md mt-3 gilroy">Contact Information</p>
                                                                <div className="row">
                                                                    <div className="col-md-6">
                                                                        <CustomInput
                                                                            label="First Name"
                                                                            labelclass="mainLabel"
                                                                            type="text"
                                                                            placeholder="Enter First Name"
                                                                            inputclass="mainInput"
                                                                            id="contactInfo.first_name"
                                                                            requiredStar
                                                                            value={values.contactInfo.first_name}
                                                                            onChange={handleChange}
                                                                            onBlur={handleBlur}
                                                                            error={touched.contactInfo?.first_name && errors.contactInfo?.first_name}
                                                                        />
                                                                    </div>
                                                                    <div className="col-md-6">
                                                                        <CustomInput
                                                                            label="Last Name"
                                                                            labelclass="mainLabel"
                                                                            type="text"
                                                                            placeholder="Enter Last Name"
                                                                            inputclass="mainInput"
                                                                            id="contactInfo.last_name"
                                                                            requiredStar
                                                                            value={values.contactInfo.last_name}
                                                                            onChange={handleChange}
                                                                            onBlur={handleBlur}
                                                                            error={touched.contactInfo?.last_name && errors.contactInfo?.last_name}
                                                                        />
                                                                    </div>
                                                                </div>
                                                                <CustomInput
                                                                    label="Email"
                                                                    labelclass="mainLabel"
                                                                    type="email"
                                                                    placeholder="Enter Email"
                                                                    inputclass="mainInput"
                                                                    id="contactInfo.email"
                                                                    name="contactInfo.email"
                                                                    requiredStar
                                                                    value={values.contactInfo.email}
                                                                    onChange={handleChange}
                                                                    onBlur={handleBlur}
                                                                    error={touched.contactInfo?.email && errors.contactInfo?.email}
                                                                />
                                                                <div>
                                                                    <label htmlFor="" className="mainLabel">Phone Number<span className="redColor">*</span></label>
                                                                    <IntlTelInput
                                                                        containerClassName="intl-tel-input w-100 mb-3"
                                                                        inputClassName="mainInput"
                                                                        placeholder="Enter Phone Number"
                                                                        value={values.contactInfo.phone}
                                                                        onChangeNumber={true}
                                                                        onPhoneNumberChange={(isValid,
                                                                            value,
                                                                            selectedCountryData,
                                                                            fullNumber,) => {
                                                                            console.log("isValid", isValid);
                                                                            console.log("value", value);
                                                                            console.log("selectedCountryData", selectedCountryData);

                                                                            setFieldValue('contactInfo.phone', fullNumber);
                                                                            setFieldValue('contactInfo.dial_code', selectedCountryData?.dialCode);
                                                                            setFieldValue('contactInfo.country_code', selectedCountryData?.iso2?.toUpperCase());
                                                                        }}
                                                                        onBlur={() => handleBlur({ target: { name: 'contactInfo.phone' } })} // Mark as touched
                                                                        preferredCountries={['us', 'ca']} // Set preferred countries if needed
                                                                    />
                                                                    {touched.contactInfo?.phone && errors.contactInfo?.phone && (
                                                                        <div className="error-message">{errors.contactInfo.phone}</div>
                                                                    )}
                                                                </div>
                                                                <p className="bold p-md mt-3 gilroy">Shipping Address</p>
                                                                <div className="row">
                                                                    <div className="col-md-6">
                                                                        <CustomInput
                                                                            label="First Name"
                                                                            labelclass="mainLabel"
                                                                            type="text"
                                                                            placeholder="Enter First Name"
                                                                            inputclass="mainInput"
                                                                            id="shippingAddress.first_name"
                                                                            requiredStar
                                                                            value={values.shippingAddress.first_name}
                                                                            onChange={handleChange}
                                                                            onBlur={handleBlur}
                                                                            error={touched.shippingAddress?.first_name && errors.shippingAddress?.first_name}
                                                                        />
                                                                    </div>
                                                                    <div className="col-md-6">
                                                                        <CustomInput
                                                                            label="Last Name"
                                                                            labelclass="mainLabel"
                                                                            type="text"
                                                                            placeholder="Enter Last Name"
                                                                            inputclass="mainInput"
                                                                            id="shippingAddress.last_name"
                                                                            requiredStar
                                                                            value={values.shippingAddress.last_name}
                                                                            onChange={handleChange}
                                                                            onBlur={handleBlur}
                                                                            error={touched.shippingAddress?.last_name && errors.shippingAddress?.last_name}
                                                                        />
                                                                    </div>
                                                                </div>
                                                                <div>
                                                                    <label htmlFor="" className="mainLabel">Phone Number<span className="redColor">*</span></label>
                                                                    <IntlTelInput
                                                                        containerClassName="intl-tel-input w-100 mb-3"
                                                                        inputClassName="mainInput"
                                                                        placeholder="Enter Phone Number"
                                                                        value={values.shippingAddress.phone}
                                                                        onChangeNumber={true}
                                                                        // onChangeValidity={true}
                                                                        // onPhoneNumberChange={(selectedCountry, phone, { isValid }) => {
                                                                        //     setFieldValue('shippingAddress.phone', phone);
                                                                        // }}
                                                                        onPhoneNumberChange={(isValid,
                                                                            value,
                                                                            selectedCountryData,
                                                                            fullNumber,) => {
                                                                            console.log("isValid", isValid);
                                                                            console.log("value", value);
                                                                            console.log("selectedCountryData", selectedCountryData);

                                                                            setFieldValue('shippingAddress.phone', fullNumber);
                                                                            setFieldValue('shippingAddress.dial_code', selectedCountryData?.dialCode);
                                                                            setFieldValue('shippingAddress.country_code', selectedCountryData?.iso2?.toUpperCase());
                                                                        }}
                                                                        onBlur={() => handleBlur({ target: { name: 'shippingAddress.phone' } })} // Mark as touched
                                                                    // Set preferred countries if needed
                                                                    />
                                                                    {touched.shippingAddress?.phone && errors.shippingAddress?.phone && (
                                                                        <div className="error-message">{errors.shippingAddress.phone}</div>
                                                                    )}
                                                                </div>
                                                                <CustomInput
                                                                    label="Residential Address"
                                                                    labelclass="mainLabel"
                                                                    type="text"
                                                                    placeholder="Enter Residential Address"
                                                                    inputclass="mainInput"
                                                                    id="shippingAddress.address"
                                                                    name="shippingAddress.address"
                                                                    requiredStar
                                                                    value={values.shippingAddress.address}
                                                                    onChange={handleChange}
                                                                    onBlur={handleBlur}
                                                                    error={touched.shippingAddress?.address && errors.shippingAddress?.address}
                                                                />
                                                                <div className="row">
                                                                    <div className="col-md-6">
                                                                        <CustomInput
                                                                            label="Country"
                                                                            labelclass="mainLabel"
                                                                            type="text"
                                                                            placeholder="Enter Country"
                                                                            inputclass="mainInput"
                                                                            id="shippingAddress.country"
                                                                            name="shippingAddress.country"
                                                                            requiredStar
                                                                            value={values.shippingAddress.country}
                                                                            onChange={handleChange}
                                                                            onBlur={handleBlur}
                                                                            error={touched.shippingAddress?.country && errors.shippingAddress?.country}
                                                                        />
                                                                    </div>
                                                                    <div className="col-md-6">
                                                                        <CustomInput
                                                                            label="State"
                                                                            labelclass="mainLabel"
                                                                            type="text"
                                                                            placeholder="Enter State"
                                                                            inputclass="mainInput"
                                                                            id="shippingAddress.state"
                                                                            name="shippingAddress.state"
                                                                            requiredStar
                                                                            value={values.shippingAddress.state}
                                                                            onChange={handleChange}
                                                                            onBlur={handleBlur}
                                                                            error={touched.shippingAddress?.state && errors.shippingAddress?.state}
                                                                        />
                                                                    </div>
                                                                    <div className="col-md-6">
                                                                        <CustomInput
                                                                            label="City"
                                                                            labelclass="mainLabel"
                                                                            type="text"
                                                                            placeholder="Enter City"
                                                                            inputclass="mainInput"
                                                                            id="shippingAddress.city"
                                                                            name="shippingAddress.city"
                                                                            requiredStar
                                                                            value={values.shippingAddress.city}
                                                                            onChange={handleChange}
                                                                            onBlur={handleBlur}
                                                                            error={touched.shippingAddress?.city && errors.shippingAddress?.city}
                                                                        />
                                                                    </div>
                                                                    <div className="col-md-6">
                                                                        <CustomInput
                                                                            label="Zip Code"
                                                                            labelclass="mainLabel"
                                                                            type="text"
                                                                            placeholder="Enter Zip Code"
                                                                            inputclass="mainInput"
                                                                            id="shippingAddress.zip_code"
                                                                            name="shippingAddress.zip_code"
                                                                            requiredStar
                                                                            value={values.shippingAddress.zip_code}
                                                                            onChange={handleChange}
                                                                            onBlur={handleBlur}
                                                                            error={touched.shippingAddress?.zip_code && errors.shippingAddress?.zip_code}
                                                                        />
                                                                    </div>
                                                                </div>
                                                                <Form.Check // prettier-ignore
                                                                    type={'checkbox'}
                                                                    id={`default-billing`}
                                                                    checked={values.useDifferentBillingAddress}
                                                                    onChange={() => {
                                                                        setFieldValue("useDifferentBillingAddress", !values.useDifferentBillingAddress);
                                                                    }}
                                                                    label="Use a different billing address"
                                                                />
                                                                {values.useDifferentBillingAddress && (
                                                                    <div className={`billingAddress`}>
                                                                        <p className="bold p-md mt-3 gilroy">Billing Address</p>
                                                                        <div className="row">
                                                                            <div className="col-md-6">
                                                                                <CustomInput
                                                                                    label="First Name"
                                                                                    labelclass="mainLabel"
                                                                                    type="text"
                                                                                    placeholder="Enter First Name"
                                                                                    inputclass="mainInput"
                                                                                    id="billingAddress.first_name"
                                                                                    name="billingAddress.first_name"
                                                                                    requiredStar
                                                                                    value={values.billingAddress.first_name}
                                                                                    onChange={handleChange}
                                                                                    onBlur={handleBlur}
                                                                                    error={touched.billingAddress?.first_name && errors.billingAddress?.first_name}
                                                                                />
                                                                            </div>
                                                                            <div className="col-md-6">
                                                                                <CustomInput
                                                                                    label="Last Name"
                                                                                    labelclass="mainLabel"
                                                                                    type="text"
                                                                                    placeholder="Enter Last Name"
                                                                                    inputclass="mainInput"
                                                                                    id="billingAddress.last_name"
                                                                                    name="billingAddress.last_name"
                                                                                    requiredStar
                                                                                    value={values.billingAddress.last_name}
                                                                                    onChange={handleChange}
                                                                                    onBlur={handleBlur}
                                                                                    error={touched.billingAddress?.last_name && errors.billingAddress?.last_name}
                                                                                />
                                                                            </div>
                                                                        </div>
                                                                        <div>
                                                                            <label htmlFor="" className="mainLabel">Phone Number<span className="redColor">*</span></label>
                                                                            <IntlTelInput
                                                                                containerClassName="intl-tel-input w-100 mb-3"
                                                                                inputClassName="mainInput"
                                                                                placeholder="Enter Phone Number"
                                                                                value={values.billingAddress.phone}
                                                                                onChangeNumber={true}
                                                                                name="billingAddress.phone"
                                                                                // onChangeValidity={true}
                                                                                // onPhoneNumberChange={(selectedCountry, phone, { isValid }) => {
                                                                                //     setFieldValue('billingAddress.phone', phone);
                                                                                // }}
                                                                                onPhoneNumberChange={(isValid,
                                                                                    value,
                                                                                    selectedCountryData,
                                                                                    fullNumber,) => {
                                                                                    console.log("isValid", isValid);
                                                                                    console.log("value", value);
                                                                                    console.log("selectedCountryData", selectedCountryData);

                                                                                    setFieldValue('billingAddress.phone', fullNumber);
                                                                                    setFieldValue('billingAddress.dial_code', selectedCountryData?.dialCode);
                                                                                    setFieldValue('billingAddress.country_code', selectedCountryData?.iso2?.toUpperCase());
                                                                                }}
                                                                                onBlur={() => handleBlur({ target: { name: 'billingAddress.phone' } })} // Mark as touched
                                                                                preferredCountries={['us', 'ca']} // Set preferred countries if needed
                                                                            />
                                                                            {touched.billingAddress?.phone && errors.billingAddress?.phone && (
                                                                                <div className="error-message">{errors.billingAddress.phone}</div>
                                                                            )}
                                                                        </div>
                                                                        <CustomInput
                                                                            label="Residential Address"
                                                                            labelclass="mainLabel"
                                                                            type="text"
                                                                            placeholder="Enter Residential Address"
                                                                            inputclass="mainInput"
                                                                            id="billingAddress.address"
                                                                            name="billingAddress.address"
                                                                            requiredStar
                                                                            value={values.billingAddress.address}
                                                                            onChange={handleChange}
                                                                            onBlur={handleBlur}
                                                                            error={touched.billingAddress?.address && errors.billingAddress?.address}
                                                                        />
                                                                        <div className="row">
                                                                            <div className="col-md-6">
                                                                                <CustomInput
                                                                                    label="Country"
                                                                                    labelclass="mainLabel"
                                                                                    type="text"
                                                                                    placeholder="Enter Country"
                                                                                    inputclass="mainInput"
                                                                                    id="billingAddress.country"
                                                                                    name="billingAddress.country"
                                                                                    requiredStar
                                                                                    value={values.billingAddress.country}
                                                                                    onChange={handleChange}
                                                                                    onBlur={handleBlur}
                                                                                    error={touched.billingAddress?.country && errors.billingAddress?.country}
                                                                                />
                                                                            </div>
                                                                            <div className="col-md-6">
                                                                                <CustomInput
                                                                                    label="State"
                                                                                    labelclass="mainLabel"
                                                                                    type="text"
                                                                                    placeholder="Enter State"
                                                                                    inputclass="mainInput"
                                                                                    id="billingAddress.state"
                                                                                    name="billingAddress.state"
                                                                                    requiredStar
                                                                                    value={values.billingAddress.state}
                                                                                    onChange={handleChange}
                                                                                    onBlur={handleBlur}
                                                                                    error={touched.billingAddress?.state && errors.billingAddress?.state}
                                                                                />
                                                                            </div>
                                                                            <div className="col-md-6">
                                                                                <CustomInput
                                                                                    label="City"
                                                                                    labelclass="mainLabel"
                                                                                    type="text"
                                                                                    placeholder="Enter City"
                                                                                    inputclass="mainInput"
                                                                                    id="billingAddress.city"
                                                                                    name="billingAddress.city"
                                                                                    requiredStar
                                                                                    value={values.billingAddress.city}
                                                                                    onChange={handleChange}
                                                                                    onBlur={handleBlur}
                                                                                    error={touched.billingAddress?.city && errors.billingAddress?.city}
                                                                                />
                                                                            </div>
                                                                            <div className="col-md-6">
                                                                                <CustomInput
                                                                                    label="Zip Code"
                                                                                    labelclass="mainLabel"
                                                                                    type="text"
                                                                                    placeholder="Enter Zip Code"
                                                                                    inputclass="mainInput"
                                                                                    id="billingAddress.zip_code"
                                                                                    name="billingAddress.zip_code"
                                                                                    requiredStar
                                                                                    value={values.billingAddress.zip_code}
                                                                                    onChange={handleChange}
                                                                                    onBlur={handleBlur}
                                                                                    error={touched.billingAddress?.zip_code && errors.billingAddress?.zip_code}
                                                                                />
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                )}

                                                                <div className="mt-4">
                                                                    <CustomButton
                                                                        pendingText="Loading..."
                                                                        isPending={isSubmitting}
                                                                        className="btnBlueBG px-5"
                                                                        text="Place Order"
                                                                        type="submit"
                                                                    />
                                                                </div>
                                                            </div>
                                                        </form>
                                                    )
                                                }}
                                            </Formik>

                                        </div>
                                        <div className="col-lg-5">
                                            <div className="summary-card">
                                                <CustomTable
                                                    noFilters
                                                    headers={checkoutCartHeaders}
                                                >
                                                    {loading ? (
                                                        <LoadingSpinner rollerStyle={{ left: "100%", transform: 'translateX(100%)' }} />

                                                    ) : data.length > 0 ? (
                                                        <tbody className={`${loading ? '' : 'text-center'}`}>
                                                            {data?.map((item, index) => (
                                                                <tr key={item?.id}>
                                                                    <td>{index < 10 ? `0${index + 1}` : index}</td>
                                                                    <td className='mnw-190'>
                                                                        <div className="d-flex align-items-center gap-2">
                                                                            <div className="flex-shrink-0">
                                                                                <img src={item?.product?.images[0]?.path} alt="" className="img-fluid category-img-sm" />
                                                                            </div>
                                                                            <div className="flex-grow-1">
                                                                                <p className="mb-0">{item?.product?.name}</p>
                                                                                <p className="mb-0 mt-1">{item?.product?.category?.name}</p>
                                                                            </div>
                                                                        </div>
                                                                    </td>
                                                                    <td>{item?.quantity}</td>
                                                                    <td>{item?.size?.name}</td>
                                                                    <td>${item?.price}</td>
                                                                </tr>
                                                            ))}
                                                        </tbody>
                                                    ) : (
                                                        <div>
                                                            <p>Data not found</p>
                                                        </div>
                                                    )}
                                                </CustomTable>
                                                <p className="p-md mb-0 gilroy bold">Order Summary</p>
                                                <div className="d-flex mt-3 justify-content-between align-items-center">
                                                    <p className="mb-0">Sub Total</p>
                                                    <p className="mb-0">${calculateTotalPrice(data)}</p>
                                                </div>
                                                <div className="d-flex mt-3 justify-content-between align-items-center">
                                                    <p className="mb-0">Delivery Charges</p>
                                                    <p className="mb-0">${deliveryCharges?.amount}</p>
                                                </div>
                                                <hr />
                                                <div className="d-flex pb-4 mt-3 justify-content-between align-items-center">
                                                    <p className="mb-0">Total</p>
                                                    <p className="mb-0">${calculateTotalPrice(data) + deliveryCharges?.amount}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </UserLayout >
            <CustomModal
                show={showModal}
                close={() => setShowModal(false)}
                action={createOrder}
                heading="Are you sure you want to place order?"
            />
            <CustomModal
                show={showModalSuccess}
                close={() => {
                    setShowModalSuccess(false)
                    navigate('/')
                }}
                success
                heading="Order has been placed successfully"
            />
        </>
    );
}

export default Checkout;
