import { useState } from "react";
import "./style.css";
import CustomModal from "../../../Components/CustomModal";
import { post } from "../../../Services/Api";
import ContactForm from "../../../Components/ContactForm";
import { UserLayout } from "../../../Components/user/Layout";
import { useNavigate } from "react-router-dom";

const ContactUs = () => {
  const [showModal, setShowModal] = useState(false);

  const handleSubmit = async (values, { resetForm }) => {
    let response = await post("/contact-us", values);
    if (response.status) {
      setShowModal(true);
      resetForm();
    }
  };

  const navigate = useNavigate();

  return (
    <>
      <UserLayout pageTitle="Contact Us">
        <section className="contact-us py-sm-5 py-4">
          <div className="container">
            <div className="row">
              <div className="col-12">
                <div className="contact-card">
                  <div className="contact-card-inner">
                    <h4 className="heavy mb-4 text-center">Contact Us</h4>
                    <ContactForm handleSubmit={handleSubmit} />
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>

        <CustomModal
          show={showModal}
          close={() => {
            setShowModal(false);
            navigate("/");
          }}
          success
          heading="Your message has been submitted successfully"
        />
      </UserLayout>
    </>
  );
};

export default ContactUs;
