import { useState, useEffect } from "react";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import StatCard from "../../../Components/StatsCard/index";
import CustomButtonLink from "../../../Components/CustomButtonLink";
import "./style.css";
import { getAll } from "../../../Services/Api";
import { cardLinks, generateNextFiveYears, getIcon, getText } from "../../../Utils/helper";
import { Graph } from "../../../Components/Graph";

export const Dashboard = () => {
  const [data, setData] = useState([]);
  const [orderChart, setOrderChart] = useState([]);
  const [selectedValue, setSelectedValue] = useState("2024");
  const [chartdata, setChartData] = useState({});

  const fetchHomeData = async () => {
    try {
      const response = await getAll("/branch-api/account/home");

      if (response && response.status) {
        setData(
          Object.entries(response?.detail).map(([key, value]) => ({
            id: key,
            image: getIcon(key),
            text: getText(key),
            change: value.total,
            increase: value.trend,
            sinceWeek: "since last week",
            link: cardLinks(key)
          }))
        );
      }
    } catch (error) {
      console.error("Error fetching home data:", error);
    }
  };

  const handleSelectChange = (value) => {
    setSelectedValue(value);
    fetchOrderChart(value);
  };

  const fetchOrderChart = async (value) => {
    try {
      const response = await getAll("/branch-api/charts/order?year=" + value);
      if (response && response.status) {
        setOrderChart(response.detail);
        setChartData({
          data: response.detail,
          label: "orders",
          heading: "Orders",
        });
      }
    } catch (error) {
      console.error("Error fetching home data:", error);
    }
  };

  useEffect(() => {
    fetchHomeData();
    fetchOrderChart(selectedValue);
  }, []);

  const years = generateNextFiveYears(); // Generate the next five years


  return (
    <>
      <DashboardLayout pageTitle="Dashboard">
        <div className="container-fluid">
          <div className="row mb-3">
            <div className="col-12">
              <div className="dashCard pb-3">
                <div className="row mb-5">
                  <div className="col-md-6">
                    <h2 className="mainTitle mb-0">Dashboard</h2>
                  </div>
                  <div className="col-md-6">
                    <div className="d-flex justify-content-end">
                      <CustomButtonLink
                        className="btnBlueBG"
                        linkPath="/branch/ongoing-orders"
                        text="View New Order"
                      />
                    </div>
                  </div>
                </div>
                <div className="row">
                  {data?.map((stats) => (
                    <div className="col-md-4 mb-3" key={stats.id}>
                      <StatCard item={stats} statsChange={false} />
                    </div>
                  ))}
                </div>
              </div>
            </div>
          </div>
          <div className="row mb-3">
            <div className="col-12">
              <Graph
                item={chartdata}
                selectedValue={selectedValue}
                onSelectChange={handleSelectChange}
                options={years}
              />
            </div>
          </div>
        </div>
      </DashboardLayout>
    </>
  );
};
