import React from 'react';
import { UserLayout } from '../../../Components/user/Layout';
import InnerBanner from '../../../Components/user/InnerBanner/InnerBanner';
import CustomButton from '../../../Components/CustomButton';
import { useNavigate } from 'react-router-dom';
import { images } from '../../../Assets';
import './index.css'
import { Accordion } from 'react-bootstrap';

const FAQs = () => {
    const navigate = useNavigate();
    return (
        <UserLayout>
            <InnerBanner title={'FAQs'} className="about-banner about-banner-sm" />
            <section className="py-sm-5 py-4">
                <div className="container">
                    <div className="row align-items-center">
                        <div className="col-xxl-10 col-lg-11 mx-auto col-12">
                            <Accordion className='site-accordion' defaultActiveKey="0">
                                <Accordion.Item eventKey="0">
                                    <Accordion.Header>Can we trust Banded isn't a scam?</Accordion.Header>
                                    <Accordion.Body>
                                        <p>We better not be—or we’ll shut it down ourselves. We understand that trust in society is low,
                                            especially with dating apps. Banded is here to be a light in the dark for men and women.
                                            Knowing that the economy is tough on everyone, we’ve kept costs as low as possible for our
                                            users. As we grow, we’ll seek partnerships with restaurants to offer discounts attached to your
                                            bands, adding value to hopefully pay for your band for you. We need you to help the movement
                                            grow.</p>
                                        <p className='mb-0'>Every dollar from band purchases goes back into this movement. We’ll never sell to Match.com
                                            or help big corporations monopolize dating services. Instead, we’ll stand and fight for what truly
                                            matters—and we need your support to do that.</p>
                                    </Accordion.Body>
                                </Accordion.Item>
                                <Accordion.Item eventKey="2">
                                    <Accordion.Header>Why did Banded start?</Accordion.Header>
                                    <Accordion.Body>
                                        <p className="mb-0">Banded was created in response to today’s relationship struggles and disconnection. We
                                            believe people deserve better and life deserves more. Our mission is to bridge the divide in
                                            today’s “gender war” and bring men and women back together against forces that drive us
                                            apart. If you’re here, it’s because you believe in this movement, too—thank you for helping us
                                            build something that truly matters.</p>
                                    </Accordion.Body>
                                </Accordion.Item>
                                <Accordion.Item eventKey="3">
                                    <Accordion.Header>What makes Banded different from other dating apps?</Accordion.Header>
                                    <Accordion.Body>
                                        <p className="mb-0">Banded focuses on fostering real-life connections through our “tap to match” feature, powered
                                            by NFC-enabled bands. We’re dedicated to helping people meet face-to-face, moving beyond
                                            the swiping and endless algorithms. Banded is a movement against swipe culture; we’re here to
                                            reconnect people in person.</p>
                                    </Accordion.Body>
                                </Accordion.Item>
                                <Accordion.Item eventKey="4">
                                    <Accordion.Header>How does the “tap to match” feature work, and what happens if the other person
                                        doesn’t have the app?</Accordion.Header>
                                    <Accordion.Body>
                                        <p className="mb-0">When two users meet, they can tap their bands near a phone to instantly trade profiles. If the
                                            other person doesn’t have the app, the band will redirect them to our website, showing your
                                            limited profile and prompting them to join Banded. So go ahead—tap your band with anyone
                                            who asks what you’re wearing and lead the way in the rebellion towards a better society</p>
                                    </Accordion.Body>
                                </Accordion.Item>
                                <Accordion.Item eventKey="5">
                                    <Accordion.Header>Is Banded waterproof?</Accordion.Header>
                                    <Accordion.Body>
                                        <p>Yes! Banded bands are designed to be waterproof, ready for any environment. We chose
                                            durable materials to withstand everyday wear and keep up with you, no matter the weather or
                                            activity.</p>
                                        <p className="mb-0">Plus every band glows in the dark! How cool?!</p>
                                    </Accordion.Body>
                                </Accordion.Item>

                                <Accordion.Item eventKey="6">
                                    <Accordion.Header>What’s the return and refund policy for Banded bands?</Accordion.Header>
                                    <Accordion.Body>
                                        <p className="mb-0">Currently, due to our small team, we don’t offer refunds or returns. However, if your band size
                                            isn’t right, email us at bandeddating@gmail.com, and we’ll send a new one free of charge. Keep
                                            the old band and pass it on to a friend to keep the movement going. We’re here to build a
                                            community, not to make a quick profit, and the shipping costs alone wouldn’t be worth it for
                                            returns.</p>
                                    </Accordion.Body>
                                </Accordion.Item>
                                <Accordion.Item eventKey="7">
                                    <Accordion.Header>Does Banded service the LGBTQ+ community?</Accordion.Header>
                                    <Accordion.Body>
                                        <p className="mb-0">For dating, not at this time but feel free to use The Social Band (Tan) to network and find new
                                            friends. The Social Band was designed for everyone!</p>
                                    </Accordion.Body>
                                </Accordion.Item>
                                <Accordion.Item eventKey="8">
                                    <Accordion.Header>Is Banded safe for in-person matching?</Accordion.Header>
                                    <Accordion.Body>
                                        <p className="mb-0">Yes, Banded has multiple safety features: a safety pin to hide locations, facial verification for
                                            map access, and ghost mode to turn off location sharing while blocking others from seeing you.
                                            Plus you’ll get notifications if someone is close by that we think you should Tap to Match with!</p>
                                    </Accordion.Body>
                                </Accordion.Item>

                                <Accordion.Item eventKey="9">
                                    <Accordion.Header>Can I message someone on Banded without meeting them in person first?</Accordion.Header>
                                    <Accordion.Body>
                                        <p className="mb-0">Yes, messaging is open on the platform, but message requests must be accepted by the other
                                            user before a conversation can begin.</p>
                                    </Accordion.Body>
                                </Accordion.Item>
                                <Accordion.Item eventKey="1">
                                    <Accordion.Header>Can someone copy Banded?</Accordion.Header>
                                    <Accordion.Body>
                                        <p className="mb-0">Technically for now, yes, but we have a high level patent pending for our tech and unique
                                            coding. If you see anyone else trying to copy us, email us at bandeddating@gmail.com, and
                                            we’ll keep them on our radar. If we have to, once the patent is approved we will sue. We don’t
                                            want to go that route, but we will protect our community and uphold what we’ve built for you. We
                                            will always aim to protect you and Banded.</p>
                                    </Accordion.Body>
                                </Accordion.Item>
                            </Accordion>
                        </div>
                    </div>
                </div>
            </section>
            {/* <section className="join-our-community how-it-works-join">
                <div className="container">
                    <div className="row">
                        <div className="col-12">
                            <div className="join-our-community-inner py-sm-5">
                                <h4 className="heavy">Ready to Tap In?</h4>
                                <p className='my-4'>Sign up for Banded today and start making real connections. Tap your band to meet people, socialize, <br /> and build authentic relationships with unlimited messaging.</p>
                                <CustomButton onClick={() => navigate('/register')} text="Join Today" className="yellow-btn px-5" />
                            </div>
                        </div>
                    </div>
                </div>
            </section> */}
        </UserLayout>
    );
}

export default FAQs;
