import React from 'react';
import CustomButton from '../../../../Components/CustomButton';
import { images } from '../../../../Assets';
import { useSelector } from 'react-redux';
import { useNavigate } from 'react-router-dom';

const Banner = () => {
    const sessionId = useSelector((state) => state?.sessionId);
    console.log("state token", sessionId);
    const navigate = useNavigate();
    const overviewInfo = [
        {
            key: 1,
            title: 'Rebel',
            description: 'Fight back against swipe culture, make the switch to Tap to Match',
            icon: images.bannerIcon1
        },
        {
            key: 2,
            title: 'Revive',
            description: "Let's make dating fun again",
            icon: images.bannerIcon2
        },
        {
            key: 3,
            title: 'Reconnect',
            description: 'Doing this together one band at a time',
            icon: images.bannerIcon3
        },
    ]
    return (
        <section className="banner py-sm-5 py-4">
            <div className="container">
                <div className="row align-items-center">
                    <div className="col-lg-7 my-3">
                        <p className="p-md semi-bold secondaryColor mb-0">Join The Rebellion</p>
                        <h1>Confidence Worn <br /> <span className='secondaryColor'> Matches </span> Born</h1>
                        <p className="darkGray">Forge genuine connections that transcend screens and ignite <br /> real-world relationships</p>
                        <CustomButton text="Join Today" onClick={() => navigate('/register')} />
                        <div className="row mt-3">
                            {overviewInfo.map((item, index) => (
                                <div className="col-md-4 col-sm-6 my-3" key={index}>
                                    <div className="d-flex gap-3">
                                        <div className="flex-shrink-0">
                                            <div className="banner-icon mt-3">
                                                <img src={item.icon} alt="" className="img-fluid" />
                                            </div>
                                        </div>
                                        <div className="flex-grow-1">
                                            <p className="p-md semi-bold mb-0">{item.title}</p>
                                            <p className="greyColor p-sm mb-0">{item.description}</p>
                                        </div>
                                    </div>
                                </div>
                            ))}
                        </div>
                    </div>
                    <div className="col-lg-5 my-3 ps-lg-5 text-lg-end text-center">
                        <img src={images.userBannerImg} alt="" className="img-fluid" />
                    </div>
                </div>
            </div>
        </section>
    );
}

export default Banner;
