import React from 'react';
import CustomButton from '../../../../Components/CustomButton';
import { useNavigate } from 'react-router-dom';

const JoinOurCommunity = () => {
    const navigate = useNavigate();
    return (
        <section className="join-our-community pb-sm-5 pb-4">
            <div className="container">
                <div className="row">
                    <div className="col-12">
                        <div className="join-our-community-inner py-sm-5">
                            <h4 className="heavy">Join Our Community</h4>
                            <p className='my-4'>Banded is more than just an app—it's a movement to bring people back together, face to face. In a world where swiping has replaced real connection, it will take all of us to revive authentic relationships and rebuild the sense of community that’s been lost. By embracing in-person interactions and fostering meaningful connections, Banded empowers each of us to play a role in reconnecting the world, one tap at a time.</p>
                            <CustomButton text="Join Today" className="yellow-btn" onClick={() => navigate('/register')} />
                        </div>
                    </div>
                </div>
            </div>
        </section>
    );
}

export default JoinOurCommunity;
