import React from 'react';
import { images } from '../../../../Assets';
import { Link } from 'react-router-dom';

const MeetNewPeople = () => {
    const meetNewPeople = [
        {
            key: '1',
            icon: images.connectionIcon1,
            title: 'New Requests',
            description: 'Send a message request to anyone on the platform at anytime',
            path: '/how-it-works'
        },
        {
            key: '2',
            icon: images.connectionIcon2,
            title: 'Connected Users',
            description: 'Unlimited messaging once requests are accepted and no pay walls',
            path: '/how-it-works'
        },
        {
            key: '3',
            icon: images.connectionIcon3,
            title: 'Find New Matches',
            description: 'Use the map or nearby notifications to meet new people and try “Tap To Match”',
            path: '/how-it-works'
        },
    ]
    return (
        <section className="meet-new-people text-center py-sm-5 py-4">
            <div className="container">
                <div className="row">
                    <div className="col-12">
                        <h2 className='bold'>Meeting <span className="secondaryColor"> new people</span>, having new <br /> <span className="secondaryColor"> experiences</span>, <span className="primaryColor"> connecting </span> with each other <br /> - That's our <span className="secondaryColor site-underline"> mission </span></h2>
                    </div>
                    <div className="col-12 mt-lg-5 mt-4">
                        <div className="meet-new-people-inner">
                            <div className="row">
                                <div className="col-sm-11 mx-auto col-12">
                                    <div className="row">
                                        {meetNewPeople.map((item, index) => (
                                            <div className="col-md-4 col-sm-6 col-12" key={index}>
                                                <div className="meet-card">
                                                    <div className="meet-icon">
                                                        <img src={item.icon} alt="" className="img-fluid" />
                                                    </div>
                                                    <div className="meet-card-inner mt-3">
                                                        <p className="p-md bold mb-0">{item.title}</p>
                                                        <p className="p-sm light">{item.description}</p>
                                                        <Link to={item.path} className="bold gilroy whiteColor">Learn More</Link>
                                                    </div>
                                                </div>
                                            </div>
                                        ))}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    );
}

export default MeetNewPeople;
