import React from 'react';
import { Link } from 'react-router-dom';
import { images } from '../../../../Assets';

const ScanNFATag = () => {
    return (
        <section className="scan-nfa-tag pb-sm-5 pb-4">
            <div className="container">
                <div className="row align-items-center">
                    <div className="col-lg-7 pe-5 my-3">
                        <h3 className='heavy'>Tap to Match And <br /> Map Access</h3>
                        <p className="my-4">"Tap to Match" on Banded allows users to connect in person by tapping their Bands to a phone, instantly exchanging profiles for potential matches and stores them in their queue for later review. For added safety, Banded's geofencing system notifies users when compatible matches are nearby and includes a blackout radius pin that users can activate to shut off their location, ensuring privacy while preventing unwanted tracking.</p>
                        <div className="d-flex align-items-center gap-3 mt-3 flex-wrap">
                            <Link to={''}>
                                <img src={images.appleStore} alt="" className="img-fluid" />
                            </Link>
                            <Link to={''}>
                                <img src={images.playStore} alt="" className="img-fluid" />
                            </Link>
                        </div>
                    </div>
                    <div className="col-lg-5 text-end my-3">
                        <img src={images.tapToMatch} alt="" className="img-fluid" />
                    </div>
                </div>
            </div>
        </section>
    );
}

export default ScanNFATag;
