import React, { useEffect, useState } from 'react';
import { profiles } from '../../../../Config/userData';
import ProfileCard from '../../../../Components/user/ProfileCard/ProfileCard';
import { Link } from 'react-router-dom';
import { getAll } from '../../../../Services/Api';

const TopProfile = () => {
    const [data, setData] = useState([]);
    const [loading, setLoading] = useState(true);
    const [topProfiles, setTopProfiles] = useState([]);
    const fetchData = async () => {
        setLoading(true);
        const response = await getAll(`user/profile/getTopProfiles`);
        if (response.status) {
            setData(response.data);
        }
        setLoading(false);
    };

    useEffect(() => {
        fetchData();
        let topProfilesData = profiles.filter(item => item.top);
        setTopProfiles(topProfilesData)
    }, [profiles]);
    return (
        <section className="top-profiles py-sm-5 py-4">
            <div className="container">
                <div className="row">
                    <div className="col-12 text-center my-3">
                        <h3 className="heavy">Top Profiles</h3>
                        <p className='mb-0'>The Top Profiles section showcases the most active users in your area, based on recent real-life interactions. It highlights  <br /> those embracing in-person connections, helping you discover and engage with like-minded individuals nearby</p>
                        <div className="row">
                            {data?.map(((item, index) => (
                                <div className="col-xxl-3 col-lg-4 my-3 col-sm-6 col-12" key={index}>
                                    <Link to={`/top-profile-view/${item.id}`} className='no-underline'>
                                        <ProfileCard {...item} />
                                    </Link>
                                </div>

                            )))}
                        </div>
                    </div>
                </div>
            </div>
        </section>
    );
}

export default TopProfile;
