import React from 'react';
import { UserLayout } from '../../../Components/user/Layout';
import InnerBanner from '../../../Components/user/InnerBanner/InnerBanner';
import CustomButton from '../../../Components/CustomButton';
import { useNavigate } from 'react-router-dom';
import { images } from '../../../Assets';
import './index.css'

const HowItWorks = () => {
    const navigate = useNavigate();
    return (
        <UserLayout>
            <InnerBanner title={'How It Works'} className="about-banner about-banner-sm" />
            <section className="how-it-works-section-1 py-sm-5 py-4">
                <div className="container">
                    <div className="row align-items-center">
                        <div className="col-lg-6 my-3">
                            <div style={{ maxWidth: 550 }}>
                                <span className="how-it-works-tag">Step 1</span>
                                <h4 className="heavy mb-3" style={{ maxWidth: 460 }}>The Bands and What They Mean</h4>
                                <p className='mb-2'>Banded introduces a simple, color-coded system to streamline connections:</p>
                                <ul className='mb-0'>
                                    <li className='mb-2'><span className="bold">Green Bands:</span> Men looking for women.</li>
                                    <li className='mb-2'><span className="bold">White Bands:</span> Women looking for men.</li>
                                    <li className='mb-2'><span className="bold">Tan Bands:</span> The Social Band - for those interested in social networking and building friendships.</li>
                                </ul>
                                <p className='mb-0'>Our matching system ensures that you're connecting with the right people. Green and white bands match exclusively for dating, while tan bands are designed for social interactions only—for meeting new friends or expanding your network.</p>
                            </div>
                        </div>
                        <div className="col-lg-6 ps-lg-5 my-3 text-center">
                            <img src={images.howItWorks1} alt="" className="img-fluid" />
                        </div>
                    </div>
                </div>
            </section>
            <section className="how-it-works-section-2 py-sm-5 py-4">
                <div className="container">
                    <div className="row align-items-center">
                        <div className="col-lg-6 pe-lg-5 my-3 order-lg-1 order-2 text-center">
                            <img src={images.howItWorks2} alt="" className="img-fluid" />
                        </div>
                        <div className="col-lg-6 my-3 order-lg-2 order-1">
                            <span className="how-it-works-tag mb-3">Step 2</span>
                            <h4 className="heavy mb-3" style={{ maxWidth: 460 }}>Setting Up Your Band</h4>
                            <p style={{ maxWidth: 500 }}>When you create your Banded profile, you'll be prompted to sync your band with your profile. This step ensures your band is linked exclusively to you and carries your profile information for in-person interactions.</p>
                            <p style={{ maxWidth: 500 }} className='mb-0'>Once your profile is set, wear your band to make real-life connections instantly.</p>
                        </div>
                    </div>
                </div>
            </section>
            <section className="how-it-works-section-1 py-sm-5 py-4">
                <div className="container">
                    <div className="row align-items-center">
                        <div className="col-lg-6 my-3">
                            <span className="how-it-works-tag">Step 3</span>
                            <h4 className="heavy mb-3" style={{ maxWidth: 460 }}>PATENT PENDING Tap to Match: Meet In-Person, Match Instantly</h4>
                            <p className='mb-2'>Banded's Tap to Match feature brings real-world interactions back into dating and social networking:</p>
                            <ul className='mb-0'>
                                <li className='mb-2'><span className="bold">Wear Your Band:</span> Your NFC-enabled band is synced with your Banded profile.</li>
                                <li className='mb-2'><span className="bold">Tap Your Band on Their Phone:</span> When you're near someone who catches your eye, simply tap your band and the heart logo on their phone.</li>
                                <li className='mb-2'><span className="bold">Instant Connection:</span> Both profiles are exchanged, saved in your queue, and ready to explore later.</li>
                            </ul>
                            <p className='mb-0'>Once you both agree to the match, you unlock the ability to chat and view each other's full profiles. You can message anyone on the platform, but a message request must be accepted before full communication begins.</p>
                        </div>
                        <div className="col-lg-6 ps-lg-5 my-3 text-center">
                            <img src={images.howItWorks3} alt="" className="img-fluid" />
                        </div>
                    </div>
                </div>
            </section>
            <section className="how-it-works-section-2 py-sm-5 py-4">
                <div className="container">
                    <div className="row align-items-center">
                        <div className="col-lg-6 pe-lg-5 my-3 order-lg-1 order-2 text-center">
                            <img src={images.howItWorks4} alt="" className="img-fluid" />
                        </div>
                        <div className="col-lg-6 my-3 order-lg-2 order-1">
                            <span className="how-it-works-tag">Step 4</span>
                            <div style={{ maxWidth: 550 }}>
                                <h4 className="heavy mb-3" style={{ maxWidth: 460 }}>Geofence Notifications: Never Miss a Connection</h4>
                                <p className='mb-2'>With Banded's geofencing technology, you'll receive real-time notifications when a potential match or connection is nearby:</p>
                                <ul className='mb-0'>
                                    <li className='mb-2'><span className="bold">Automatic Alerts:</span> Set your preferences, and Banded will notify you when someone who matches your profile enters your radius.</li>
                                    <li className='mb-2'><span className="bold">Instant Awareness:</span> Whether it's a potential date or a new friend (for tan band users), you'll always know who's close, increasing your chances of meeting like-minded people in person.</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section className="how-it-works-section-1 py-sm-5 py-4">
                <div className="container">
                    <div className="row align-items-center">
                        <div className="col-lg-6 my-3">
                            <span className="how-it-works-tag">Step 5</span>
                            <h4 className="heavy mb-3" style={{ maxWidth: 460 }}>Interactive Map: See Who's Around You</h4>
                            <p className='mb-2'>Stay connected and aware of your surroundings with Banded's live map:</p>
                            <ul className='mb-0'>
                                <li className='mb-2'><span className="bold">User Locations:</span> The map shows the approximate location of nearby users who match your preferences.</li>
                                <li className='mb-2'><span className="bold">Live Map Updates:</span> See who's in your vicinity in real-time and plan to meet them on the go.</li>
                            </ul>
                            <p className='mb-0'>This feature helps you visualize your surroundings and take full advantage of nearby opportunities to connect.</p>
                        </div>
                        <div className="col-lg-6 ps-lg-5 my-3 text-center">
                            <img src={images.howItWorks5} alt="" className="img-fluid" />
                        </div>
                    </div>
                </div>
            </section>
            <section className="how-it-works-section-2 how-it-works-extra py-sm-5 py-4">
                <div className="container">
                    <div className="row align-items-center">
                        <div className="col-lg-6 pe-lg-5 my-3 order-lg-1 order-2 text-center">
                            <img src={images.howItWorks6} alt="" className="img-fluid" />
                        </div>
                        <div className="col-lg-6 my-3 order-lg-2 order-1">
                            <span className="how-it-works-tag">Step 6</span>
                            <h4 className="heavy mb-3" style={{ maxWidth: 460 }}>Add Social Media to Your Profile</h4>
                            <p className='mb-2'>Banded allows you to link your social media accounts directly to your profile:</p>
                            <ul className='mb-0'>
                                <li className='mb-2'><span className="bold">Research Before You Meet:</span> Want to know more about someone before meeting? Check out their linked social media profiles to get a better sense of their interests and personality.</li>
                                <li className='mb-2'><span className="bold">Build Trust:</span> Sharing your social media lets others feel more confident about who they're meeting.</li>
                            </ul>
                            <p className='mb-2'>No Subscriptions, No Boosts, No Bullshit Algorithms</p>
                            <p className='mb-2'>At Banded, we believe in keeping things simple and genuine. That's why:</p>
                            <ul className='mb-0'>
                                <li className='mb-2'><span className="bold">No Subscriptions:</span> You'll never have to pay to unlock basic features.</li>
                                <li className='mb-2'><span className="bold">No Boosts:</span> Everyone is on equal ground—no one can pay for better visibility.</li>
                                <li className='mb-2'><span className="bold">No Bullshit Algorithms:</span> Your matches and interactions are purely based on who you meet and connect with in real life, not some hidden formula.</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </section>
            <section className="join-our-community how-it-works-join">
                <div className="container">
                    <div className="row">
                        <div className="col-12">
                            <div className="join-our-community-inner py-sm-5">
                                <h4 className="heavy">Ready to Tap In?</h4>
                                <p className='my-4'>Sign up for Banded today and start making real connections. Tap your band to meet people, socialize, <br /> and build authentic relationships with unlimited messaging.</p>
                                <CustomButton text="Join Today" className="yellow-btn px-5" onClick={() => navigate('/register')} />
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </UserLayout>
    );
}

export default HowItWorks;
