import CustomButton from "../../../Components/CustomButton";
import { UserLayout } from "../../../Components/user/Layout";
import BackButton from "../../../Components/BackButton";
import { useEffect, useRef, useState } from "react";
import CustomModal from "../../../Components/CustomModal";
import CustomInput from "../../../Components/CustomInput";
import ProfileCard from "../../../Components/user/ProfileCard/ProfileCard";
import ImageSlider from "../../../Components/user/Slider";
import './index.css'
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faCheck, faHeart, faTimes } from "@fortawesome/free-solid-svg-icons";
import { Link } from "react-router-dom";
import { getAll, getDetails, post } from "../../../Services/Api";
import AwesomeSlider from "react-awesome-slider";
import "react-awesome-slider/dist/styles.css";
import LoadingSpinner from "../../../Components/Loader";

const InteractWithHappiness = () => {
  const [loading, setLoading] = useState(true);
  const [profiles, setProfiles] = useState([]);
  const [requestCount, setRequestCount] = useState();
  const [show, setShow] = useState(false);
  const [show2, setShow2] = useState(false);
  const [currentSlide, setCurrentSlide] = useState(0);

  const totalSlides = profiles.length;

  const handleShow = () => setShow(true);
  const handleClose = () => {
    setShow(false);
    navigate('/new-requests');
  };
  const handleShow2 = () => setShow2(true);
  const handleClose2 = () => {
    setShow2(false);
    navigate('/new-requests');
  };

  const fetchData = async () => {
    setLoading(true);
    const response = await getAll(`user/profile/getMatchedProfile`);
    if (response.status) {
      setProfiles(response.data);
    }
    setLoading(false);
  };

  const getDailyFriendRequestCount = async () => {
    setLoading(true);
    const response = await getDetails(`user/friends/getDailyFriendRequestCount`);
    if (response.status) {
      setRequestCount(response?.data?.count);
    }
    setLoading(false);
  };

  useEffect(() => {
    fetchData();
    getDailyFriendRequestCount();
  }, []);

  const goToNextSlide = () => {
    setCurrentSlide((prevSlide) => (prevSlide + 1) % totalSlides);
  };

  const goToPrevSlide = () => {
    setCurrentSlide((prevSlide) => (prevSlide - 1 + totalSlides) % totalSlides);
  };
  const rejectUser = (id) => {
    console.log("id", id);

  }
  const sendRequestToUser = async (id) => {
    setLoading(true);
    let response = await post(`/user/friends/send/${id}`);
    console.log(response);
    if (response.status) {
      getDailyFriendRequestCount();
      setLoading(false);
      fetchData();
      handleShow();
    }
    setLoading(false);
    console.log('sendRequestToUser', id);

  }
  return (
    <>
      <UserLayout pageTitle="View Profile">
        <div className="profile-bg py-sm-5 py-4">
          <div className="container">
            <div className="row">
              <div className="col-12">
                <div className="contact-card mxw-100 px-sm-5">
                  <div className="row mb-3">
                    <div className="col-12">
                      <div className="d-flex align-items-center gap-3 flex-wrap-reverse justify-content-between">
                        <div className="d-flex align-items-center gap-2">
                          <BackButton />
                          <h4 className="heavy mb-0">Interact with your happiness</h4>
                        </div>
                        <p className="p-md mb-0 gilroy bold">Total: {requestCount}/5</p>
                      </div>
                      <div className="d-flex gap-2 mt-3 align-items-end">
                        {/* <CustomInput label="Input your map link" labelClass="mainLabel" placeholder="Enter Input your map link" required inputclass="mainInput" /> */}
                        {/* <CustomButton text="Load" className="py-2 mb-3" /> */}
                      </div>
                      <div className="mt-4">
                        {/* <div className="custom-buttons">
                          <button onClick={goToPrevSlide} className="custom-prev">Previous</button>
                          <button onClick={goToNextSlide} className="custom-next">Next</button>
                        </div> */}

                        {/* Slider */}
                        {
                          loading ? (
                            <LoadingSpinner />
                          ) : (
                            <>
                              {profiles?.length > 0 ? (
                                <>
                                  <AwesomeSlider selected={currentSlide} bullets={false}>
                                    {profiles.map((item, index) => (
                                      <div className="contact-card p-0" key={index}>
                                        <Link to={`/view-interact-profile-details/${item.id}`} className="no-underline">
                                          <ProfileCard className="p-3" {...item} />
                                        </Link>
                                        <div className="custom-buttons d-flex gap-3 align-items-center justify-content-center mt-3">
                                          <button
                                            onClick={() => {
                                              goToPrevSlide();
                                              rejectUser(item?.id);
                                            }}
                                            className="custom-prev interact-btn"
                                          >
                                            <FontAwesomeIcon icon={faTimes} />
                                          </button>
                                          <button
                                            onClick={() => {
                                              goToNextSlide();
                                              sendRequestToUser(item?.id);
                                            }}
                                            className="custom-next interact-btn"
                                          >
                                            <FontAwesomeIcon icon={faCheck} />
                                          </button>
                                        </div>
                                      </div>
                                    ))}
                                  </AwesomeSlider>
                                </>
                              ) : (
                                <div>No match available.</div> // Optional: what to render if profiles is empty
                              )}
                            </>
                          )
                        }

                        {/* <div className="d-flex align-items-center justify-content-center gap-3">
                          <button className="interact-btn"><FontAwesomeIcon icon={faTimes} /></button>
                          <button className="interact-btn">
                            <FontAwesomeIcon icon={faCheck} />
                          </button>
                        </div> */}
                        {/* <button className="love-btn"><FontAwesomeIcon icon={faHeart} /></button> */}
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
      </UserLayout >
      <CustomModal
        show={show}
        close={handleClose}
        success
        heading="Request sent successfully!"
      />
      <CustomModal
        show={show2}
        close={handleClose2}
        success
        heading="Chat Request rejected successfully!"
      />
    </>
  );
};

export default InteractWithHappiness;
