import { useNavigate, useParams, useLocation } from "react-router";
import CustomButton from "../../../Components/CustomButton";
import { UserLayout } from "../../../Components/user/Layout";
import BackButton from "../../../Components/BackButton";
import { useEffect, useState } from "react";
import { profiles } from "../../../Config/userData";
import './index.css'
import { getDetails } from "../../../Services/Api";

const ViewProfileDetails = () => {
  const navigate = useNavigate();
  const { id } = useParams();
  // Get the 'user_id' from query parameters
  const location = useLocation();
  const queryParams = new URLSearchParams(location.search);
  const request_id = queryParams.get("request_id");
  const [details, setDetails] = useState({});
  const [userDetails, setUserDetails] = useState({});
  const getUser = async () => {
    const response = await getDetails(`/user/profile/${id}`);
    if (response.status) {
      setUserDetails(response.data);
    }
  };
  useEffect(() => {
    getUser()
    let profile = profiles.find(item => item.id == id);
    setDetails(profile);
  }, []);
  return (
    <>
      <UserLayout pageTitle="User Profile">
        <div className="profile-bg py-sm-5 py-4">
          <div className="container">
            <div className="row">
              <div className="col-12">
                <div className="contact-card mxw-100 px-sm-5">
                  <div className="row mb-3">
                    <div className="col-12">
                      <div className="d-flex align-items-center gap-2">
                        <BackButton />
                        <h4 className="heavy mb-0">User Profile</h4>
                      </div>
                    </div>
                  </div>
                  <div className="row mb-3">
                    <div className="col-12">
                      <div className="row mb-3">
                        <div className="col-lg-12 order-2 order-lg-1 mb-3">
                          <div className="profileImage">
                            <img src={details?.img} alt="User" />
                          </div>
                        </div>
                      </div>
                      <div className="row">
                        <div className="col-12">
                          <div className="top-profile-view-card">
                            <label className="gilroy bold mb-0">Basic Information</label>
                            <p className="mb-0">{details?.description}</p>
                            <div className="row">
                              <div className="col-md-4 col-sm-6 col-12 my-3">
                                <label className="gilroy bold mb-0">Exercise</label>
                                <p className="mb-0">{details?.exercise}</p>
                              </div>
                              <div className="col-md-4 col-sm-6 col-12 my-3">
                                <label className="gilroy bold mb-0">Education</label>
                                <p className="mb-0">{details?.education}</p>
                              </div>
                              <div className="col-md-4 col-sm-6 col-12 my-3">
                                <label className="gilroy bold mb-0">Drinking Habit</label>
                                <p className="mb-0">{details?.drinking}</p>
                              </div>
                              <div className="col-md-4 col-sm-6 col-12 my-3">
                                <label className="gilroy bold mb-0">Gender</label>
                                <p className="mb-0">{details?.gender}</p>
                              </div>
                              <div className="col-md-4 col-sm-6 col-12 my-3">
                                <label className="gilroy bold mb-0">Communication Style</label>
                                <p className="mb-0">{details?.communicationStyle}</p>
                              </div>
                              <div className="col-md-4 col-sm-6 col-12 my-3">
                                <label className="gilroy bold mb-0">Star</label>
                                <p className="mb-0">{details?.star}</p>
                              </div>
                            </div>
                            <div className="mt-3 d-flex align-items-center gap-3 flex-wrap">
                              {details?.profileImages?.map((item, index) => (
                                <img src={item} key={index} alt="" className="img-fluid profile-detail-img" />
                              ))}
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
      </UserLayout>
    </>
  );
};

export default ViewProfileDetails;
