import { useNavigate, useParams } from "react-router";
import CustomButton from "../../../Components/CustomButton";
import { UserLayout } from "../../../Components/user/Layout";
import BackButton from "../../../Components/BackButton";
import { useEffect, useState } from "react";
import { newRequest, profiles } from "../../../Config/userData";
import { images } from "../../../Assets";
import { Link } from "react-router-dom";
import ProfileCard from "../../../Components/user/ProfileCard/ProfileCard";
import { getAll } from "../../../Services/Api";
import withFilters from "../../../HOC/withFilters ";
import CustomPagination from "../../../Components/CustomPagination";
import BackButtonWithPage from "../../../Components/BackButton/BackButtonWithPage";

const NewRequests = ({ filters, setFilters, pagination, updatePagination }) => {
  const navigate = useNavigate();
  const [data, setData] = useState([]);
  const [loading, setLoading] = useState(true);
  const fetchData = async () => {
    setLoading(true);
    const response = await getAll(`user/friends/requests`, { ...filters });
    if (response.status) {
      const { total, per_page, current_page, to } = response.meta;
      setData(response.data);
      updatePagination({
        showData: to,
        currentPage: current_page,
        totalRecords: total,
        totalPages: Math.ceil(total / per_page),
      });
    }
    setLoading(false);
  };
  useEffect(() => {
    fetchData();
  }, [filters]);
  return (
    <>
      <UserLayout pageTitle="New Requests">
        <div className="profile-bg py-sm-5 py-4">
          <div className="container">
            <div className="row">
              <div className="col-12">
                <div className="contact-card mxw-100 px-sm-5">
                  <div className="row mb-3">
                    <div className="col-12">
                      <div className="d-flex align-items-center gap-3 flex-wrap-reverse justify-content-between">
                        <div className="d-flex align-items-center gap-2">
                          <BackButtonWithPage page="/" />
                          <h4 className="heavy mb-0">New Requests</h4>
                        </div>
                        <div className="d-flex align-items-center">
                          <p className="p-md gilroy bold mb-0">Total: {data?.length}</p>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div className="row mb-3">
                    {data?.map(((item, index) => (
                      <div className="col-lg-3 my-3 col-sm-6 col-12" key={index}>
                        <Link to={`/request-profile-view/${item?.sender?.id}?request_id=${item?.id}`} className='no-underline'>
                          <ProfileCard {...item?.sender} />
                        </Link>
                      </div>

                    )))}
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
      </UserLayout>
    </>
  );
};

export default withFilters(NewRequests);
