import { useState, useEffect } from "react";
import { useNavigate, useParams } from "react-router-dom";
import BackButton from "../../../Components/BackButton";
import withModal from "../../../HOC/withModal";
import { dateFormat } from "../../../Utils/helper";
import CustomTable from "../../../Components/CustomTable";
import { cartHeaders } from "../../../Config/TableHeaders";
import './style.css'
import { UserLayout } from "../../../Components/user/Layout";
import CustomModal from "../../../Components/CustomModal";
import { getDetails, post } from "../../../Services/Api";
import CustomButton from "../../../Components/CustomButton";
import IntlTelInput from 'react-intl-tel-input';
import 'react-intl-tel-input/dist/main.css';
const UserOrderDetails = ({ showModal, reasonModal }) => {
  const { id } = useParams();
  const [data, setData] = useState({});
  const [currentSelectedProduct, setCurrentSelectedProduct] = useState();
  const getOrder = async () => {
    const response = await getDetails(`/user/order/${id}`);
    if (response.status) {
      setData(response.data);
    }
  };
  useEffect(() => {
    getOrder()
  }, [id]);
  const navigate = useNavigate();
  const CartTotal = () => {
    const total = data?.details?.reduce((sum, item) => {
      return sum + item.price * item.quantity;
    }, 0);
    return total
  }
  const [show, setShow] = useState(false);
  const handleShow = (id) => {
    setCurrentSelectedProduct(id)
    setShow(true)
  };
  const handleClose = () => setShow(false);
  const [show2, setShow2] = useState(false);
  const handleClose2 = () => {
    setShow2(false)
    navigate('/my-orders')
  };
  const handleModalSubmit = async (values) => {

    // Access rating and review values here
    values.product_id = currentSelectedProduct;
    let response = await post("/user/ratings/add", values);
    if (response.status) {
      setShow(false);
      setShow2(true);
    }
    // You can now perform further actions, like sending data to an API
    // setModalVisible(false); // Close the modal after submission
  };

  const handleReportModalSubmit = async (values) => {
    console.log("values", values.reason);
    values.reportable_type = 'App\\Models\\Order';
    values.reportable_id = id;
    // Access rating and review values here
    values.product_id = currentSelectedProduct;
    let response = await post("/user/report/create", values);
    if (response.status) {
      setShow4(false);
      setShow5(true);
    }
    // You can now perform further actions, like sending data to an API
    // setModalVisible(false); // Close the modal after submission
  };
  const action = (e) => {
    console.log("form value", e);

    // setShow(false);
    // setShow2(true);
  }

  const [show3, setShow3] = useState(false);
  const handleShow3 = () => { setShow3(true) };
  const handleClose3 = () => setShow3(false);
  const [show4, setShow4] = useState(false);
  const handleClose4 = () => setShow4(false);
  const [show5, setShow5] = useState(false);
  const handleClose5 = () => setShow5(false);
  const reportAction = () => {
    setShow3(false);
    setShow4(true);
  }
  const reportedAction = () => {
    setShow4(false);
    setShow5(true);
  }

  return (
    <>
      <UserLayout pageTitle="Order Details">
        <section className="order-details py-sm-5 py-4">
          <div className="container">
            <div className="row">
              <div className="col-12">
                <div className="contact-card mxw-100">
                  <div className="d-flex align-items-center justify-content-between flex-wrap gap-3">
                    <div className="d-flex align-items-center gap-2">
                      <BackButton />
                      <h4 className="heavy mb-0">
                        Order Details
                      </h4>
                    </div>
                    <div className="text-end">
                      <div className="d-flex align-items-center justify-content-end gap-2">
                        <label className="semi-bold">Status</label>
                        <span
                          className={`semi-bold ${data?.status === "pending" ? "primaryColor" : data?.status === "cancelled" ? "redColor" : "greenColor"
                            }`}
                        >
                          {data?.status?.toUpperCase()}
                        </span>
                      </div>
                      {data?.status?.toLowerCase() === "delivered" ? (
                        <div className="mt-2">
                          <CustomButton onClick={handleShow3} text="Report" />
                        </div>
                      ) : ''}
                    </div>
                  </div>
                  <div className="d-flex gap-3 flex-lg-nowrap flex-wrap-reverse justify-content-between mb-3">
                    <div className="flex-grow-1">
                      <div className="mt-4">
                        {[
                          { label: "Order ID", value: data?.id },
                          { label: "Order Date", value: dateFormat(data?.created_at) },
                        ].map(({ label, value }) => (
                          <div className="d-flex align-items-center gap-2" key={label}>
                            <p className="gilroy mb-0 bold">{label}</p>
                            <p className="secondaryText mb-0 text-secondary">{value}</p>
                          </div>
                        ))}
                        {data?.status == "delivered" ? (
                          <div className="d-flex align-items-center gap-2">
                            <p className="gilroy mb-0 bold">Delivery Date</p>
                            <p className="secondaryText mb-0 text-secondary">{dateFormat(data?.updated_at)}</p>
                          </div>
                        ) : ""}
                      </div>
                    </div>
                  </div>
                  <div className="row">
                    <div className="col-lg-8">
                      <CustomTable
                        noFilters
                        headers={cartHeaders}
                      >
                        <tbody>
                          {data?.details?.map((item, index) => (
                            <tr key={item?.id}>
                              <td>{index < 10 ? `0${index + 1}` : index}</td>
                              <td>
                                <div className="d-flex align-items-center gap-2">
                                  <div className="flex-shrink-0">
                                    <img src={item?.product?.images[0]?.path} alt="" className="img-fluid category-img-sm" />
                                  </div>
                                  <div className="flex-grow-1">
                                    <p className="mb-0">{item?.product?.name}</p>
                                    <p className="mb-0 mt-1">{item?.product?.category?.name}</p>
                                  </div>
                                </div>
                              </td>
                              <td>${item?.price}</td>
                              <td>{item?.quantity}</td>
                              <td>
                                <p className="mb-0">
                                  ${item?.price * item?.quantity}
                                </p>
                                {data?.status == "delivered" ? (
                                  <button className="transparent-btn secondaryColor" onClick={() => handleShow(item?.product?.id)}>Write Review</button>
                                ) : ''}
                              </td>
                            </tr>
                          ))}
                        </tbody>
                      </CustomTable>
                    </div>
                    <div className="col-lg-4">
                      <div className="summary-card">
                        <p className="p-md mb-0 gilroy bold">Order Summary</p>
                        <div className="d-flex mt-3 justify-content-between align-items-center">
                          <p className="mb-0">Sub Total</p>
                          <p className="mb-0">${CartTotal()}</p>
                        </div>
                        <div className="d-flex mt-3 justify-content-between align-items-center">
                          <p className="mb-0">Delivery Charges</p>
                          <p className="mb-0">${data?.delivery_charges}</p>
                        </div>
                        <hr />
                        <div className="d-flex mt-3 justify-content-between align-items-center">
                          <p className="mb-0">Total</p>
                          <p className="mb-0">${data?.total_price}</p>
                        </div>
                        {data?.status == 'cancelled' && (
                          <div className="mt-3">
                            <p className="bold mb-0">Cancellation Reason</p>
                            <p className="mb-0">{data?.rejection_reason}</p>
                          </div>
                        )}
                      </div>
                    </div>
                  </div>

                  {data?.address
                    ?.sort((a, b) => {
                      const order = ['contact', 'shipping', 'billing'];
                      return order.indexOf(a.type) - order.indexOf(b.type);
                    })
                    .map((value, index) => (
                      <div key={index}>
                        <p className="p-md gilroy bold my-3">
                          {value?.type == 'contact' ? 'Contact' : value?.type?.charAt(0).toUpperCase() + value?.type?.slice(1).toLowerCase()}
                          {value?.type == 'contact' ? ' Information' : ' Address'}
                        </p>

                        <div className="mt-4 order-details-wrapper">
                          <div className="d-flex flex-wrap gap-4">
                            {value?.type === 'contact' && (
                              <div>
                                <p className="gilroy mb-0 bold">User Name</p>
                                <p className="secondaryText text-secondary">
                                  {value?.first_name + ' ' + value?.last_name}
                                </p>
                                <p className="gilroy bold mt-3 mb-0">Contact Number</p>
                                <p className="secondaryText text-secondary">
                                  <IntlTelInput
                                    disabled={true}
                                    containerClassName="intl-tel-input  "
                                    inputClassName="border-0"
                                    defaultCountry={value?.country_code.toLowerCase()} // Set initial country based on country code
                                    value={`${value?.dial_code}${value?.phone}`} // Combine dialing code and number
                                    separateDialCode={false} // Show dialing code separately
                                    preferredCountries={[value?.country_code.toLowerCase()]}

                                  />
                                </p>
                                <p className="gilroy bold mt-3 mb-0">Email</p>
                                <p className="secondaryText text-secondary">{value?.email}</p>
                              </div>
                            )}

                            {value?.type !== 'contact' && (
                              <div>
                                <p className="gilroy bold mb-0">Customer Name</p>
                                <p className="secondaryText text-secondary">
                                  {value?.first_name + ' ' + value?.last_name}
                                </p>
                                <p className="gilroy bold mt-3 mb-0">Contact Number</p>
                                <p className="secondaryText text-secondary">
                                  <IntlTelInput
                                    disabled={true}
                                    containerClassName="intl-tel-input  "
                                    inputClassName="border-0"
                                    defaultCountry={value?.country_code.toLowerCase()} // Set initial country based on country code
                                    value={`${value?.dial_code}${value?.phone}`} // Combine dialing code and number
                                    separateDialCode={false} // Show dialing code separately
                                    preferredCountries={[value?.country_code.toLowerCase()]}

                                  />
                                </p>

                                <p className="gilroy bold mt-3 mb-0">Address</p>
                                <p className="secondaryText text-secondary">{value?.address}</p>
                                <p className="gilroy bold mt-3 mb-0">Country</p>
                                <p className="secondaryText text-secondary">{value?.country}</p>
                                <p className="gilroy bold mt-3 mb-0">State</p>
                                <p className="secondaryText text-secondary">{value?.state}</p>
                                <p className="gilroy bold mt-3 mb-0">City</p>
                                <p className="secondaryText text-secondary">{value?.city}</p>
                                <p className="gilroy bold mt-3 mb-0">Zip Code</p>
                                <p className="secondaryText text-secondary">{value?.zip_code}</p>
                              </div>
                            )}
                          </div>
                        </div>
                      </div>
                    ))}

                </div>
              </div>
            </div>
          </div>
        </section>
      </UserLayout>
      <CustomModal
        show={show}
        actionMethod={action}
        close={handleClose}
        rateProduct={true}
        heading="Rate the Product"
        para="Please rate the product and leave a review."
        onSubmit={handleModalSubmit} // Pass the submission handler to the modal
      />
      <CustomModal
        show={show2}
        close={handleClose2}
        success
        heading="Review has been submitted"
      />
      <CustomModal
        show={show3}
        action={reportAction}
        close={handleClose3}
        heading="Report Order"
        para="Are you sure you want to report this order?"
      />
      <CustomModal
        show={show4}
        close={handleClose4}
        showReason
        action={reportedAction}
        reasonLabel="Report Reason"
        onSubmit={handleReportModalSubmit}
      // heading="Review has been submitted"
      />
      <CustomModal
        show={show5}
        close={handleClose5}
        heading="Successful"
        para="Order has been reported successfully"
        success
      // heading="Review has been submitted"
      />
    </>
  );
};

export default withModal(UserOrderDetails);
