import { faStar } from '@fortawesome/free-solid-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import React, { useEffect, useState } from 'react';
import CustomButton from '../../../Components/CustomButton';
import { Link } from 'react-router-dom';
import './index.css';
import { faHeart } from '@fortawesome/free-regular-svg-icons';
import { faHeart as filledHeart } from '@fortawesome/free-solid-svg-icons';
import { deleteData, post } from '../../../Services/Api';
import { addToCart } from '../../../Store/actions/cartActions';
import { useDispatch } from 'react-redux';
import { useNavigate } from "react-router-dom";
import { useAuth } from '../../../Hooks/useAuth';

const ProductCard = ({
    id,
    images,
    name,
    quantity,
    ratings,
    reviews,
    discounted_price,
    wishlist,
    average_rating,
    is_in_wishlist,
    price,
    item, handleAddWishlist }) => {
    const dispatch = useDispatch();
    const navigate = useNavigate();
    const { user } = useAuth();
    const addProductToWishlist = async (productId, isInWishList, wishlist) => {
        if (!user) {
            // If user is not logged in, redirect to the login page
            navigate("/login");
            return;
        }
        var response;
        if (!isInWishList) {
            response = await post('/user/wishlist/add', { product_id: productId });
        } else {
            response = await deleteData(`/user/wishlist/remove/${wishlist?.id}`);
        }
        if (response.status) {
            handleAddWishlist();
        }
    };
    const handleAddToCart = async (id) => {
        // if (!user) {
        //     // If user is not logged in, redirect to the login page
        //     navigate("/login");
        //     return;
        // }
        // let response = await post('user/cart/add', { 'product_id': id, 'quantity': 1 }); // open this whn using backend api
        // if (response.status) {
        //     dispatch(addToCart({ 'id': id, }));
        navigate(`/product-details/${id}`)
        // }
    };
    return (
        <div className="product-card">
            <div className="product-card-img position-relative">
                <Link to={`/product-details/${id}`} className='d-block w-100'>
                    <img src={images[0]?.path} alt="" className="img-fluid" />
                </Link>
                {/* <button className="transparent-btn heart-icon" onClick={() => addProductToWishlist(id, is_in_wishlist, wishlist)}><FontAwesomeIcon icon={is_in_wishlist ? filledHeart : faHeart} className='redColor' /></button> */}
                {quantity === 0 && (
                    <span className='sold-out-tag'>Sold Out</span>
                )}
            </div>
            <div className="product-card-inner d-flex flex-column justify-content-between align-items-start mt-3" style={{ minHeight: 160 }}>
                <div className="d-flex gap-3 justify-content-between flex-sm-nowrap flex-wrap-reverse w-100">
                    <div>
                        <p className="p-md mb-0 bold gilroy text-uppercase">{name}</p>
                        {/* <p className='mb-0'><FontAwesomeIcon icon={faStar} className='yellowColor' />{average_rating}({ratings?.length})</p> */}
                    </div>
                    <div>
                        <p className="p-md mb-0 bold gilroy text-uppercase">${price - discounted_price}</p>
                        <p className='mb-0'><del>${price}</del></p>
                    </div>
                </div>
                <CustomButton isPending={quantity === 0 ? true : false} className="mt-4" text="View" onClick={() => handleAddToCart(id)} />
            </div>
        </div>
    );
}

export default ProductCard;
