import { useState } from "react";
import { useNavigate } from "react-router";
import { DashboardLayout } from "../../../Components/AdminLayout/DashboardLayout";
import BackButton from "../../../Components/BackButton";
import "./style.css";
import { post } from "../../../Services/Api";
import ChangePasswordForm from "../../../Components/ChangePasswordForm";
import { useFormStatus } from "../../../Hooks/useFormStatus";
import withModal from "../../../HOC/withModal";
import { UserLayout } from "../../../Components/user/Layout";

const UserChangePassword = ({ showModal }) => {
  const navigate = useNavigate();
  const { isSubmitting, startSubmitting, stopSubmitting } = useFormStatus();
  const [errorsData, setErrorsData] = useState({});

  const handleSubmit = async (values) => {
    startSubmitting();
    console.log("values", values);

    let response = await post("/user/change-password", values);
    if (response.status) {
      stopSubmitting();
      showModal(
        `Password changed successfully`,
        null,
        true,
        '/profile'
      );
    }
    stopSubmitting();
  };
  return (
    <>
      <UserLayout pageTitle="Change Password">
        <section className="change-password py-sm-5 py-4">
          <div className="container">
            <div className="row">
              <div className="col-12">
                <div className="contact-card mxw-100">
                  <h4 className="heavy mb-4">
                    <BackButton />
                    Change Password
                  </h4>
                  <div className="row mb-3">
                    <div className="col-xl-6 col-lg-8 col-md-10 col-12">
                      <ChangePasswordForm
                        onSubmit={handleSubmit}
                        isSubmitting={isSubmitting}
                        errors={errorsData}
                      />
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
      </UserLayout>
    </>
  );
};

export default withModal(UserChangePassword);
