import { useNavigate } from "react-router";
import "./style.css";
import CustomButton from "../../../Components/CustomButton";
import { useAuth } from "../../../Hooks/useAuth";
import { UserLayout } from "../../../Components/user/Layout";
import CustomModal from "../../../Components/CustomModal";
import { useState } from "react";
import { Link } from "react-router-dom";
import IntlTelInput from 'react-intl-tel-input';
import 'react-intl-tel-input/dist/main.css';

const UserProfile = () => {
  const { user } = useAuth();
  const navigate = useNavigate();
  const [showModal, setShowModal] = useState(false);
  const handleShow = () => setShowModal(true);
  const [showModal2, setShowModal2] = useState(false);
  const handleShow2 = () => setShowModal2(true);
  return (
    <>
      <UserLayout pageTitle="My Profile">
        <div className="profile-bg py-sm-5 py-4">
          <div className="container">
            <div className="row">
              <div className="col-12">
                <div className="contact-card mxw-100 px-sm-5">
                  <div className="row mb-3">
                    <div className="col-12">
                      <h4 className="heavy">My Profile</h4>
                    </div>
                  </div>
                  <div className="my-profile-card">
                    <div className="row mb-3">
                      {user ? (
                        <>
                          <div className="col-12">
                            <div className="row mb-3">
                              <div className="col-lg-12 order-2 order-lg-1 mb-3">
                                <div className="profileImage">
                                  <img src={user?.image_url} alt="User" />
                                </div>
                                <Link to={"/change-password"} className="gilroy bold primaryColor d-block">Change Password</Link>
                              </div>
                            </div>
                            <div className="row mb-4">
                              <div className="col-sm-6 my-3">
                                <label className="gilroy bold mb-0">First Name</label>
                                <p className="secondaryText">{user?.first_name}</p>
                              </div>
                              <div className="col-sm-6 my-3">
                                <label className="gilroy bold mb-0">Last Name</label>
                                <p className="secondaryText">{user?.last_name}</p>
                              </div>
                              <div className="col-sm-6 my-3">
                                <label className="gilroy bold mb-0">Email Address</label>
                                <p className="secondaryText">{user?.email}</p>
                              </div>
                              <div className="col-sm-6 my-3">
                                <label className="gilroy bold mb-0">Age</label>
                                <p className="secondaryText">{user?.age}</p>
                              </div>
                              <div className="col-sm-6 my-3">
                                <label className="gilroy bold mb-0">Phone Number</label>
                                <IntlTelInput
                                  disabled={true}
                                  containerClassName="intl-tel-input  "
                                  inputClassName="border-0"
                                  defaultCountry={user?.country_code.toLowerCase()} // Set initial country based on country code
                                  value={`${user?.dial_code}${user?.phone}`} // Combine dialing code and number
                                  separateDialCode={false} // Show dialing code separately
                                  preferredCountries={[user?.country_code.toLowerCase()]}

                                />
                                {/* <p className="secondaryText">{user?.phone}</p> */}
                              </div>
                              <div className="col-sm-6 my-3">
                                <label className="gilroy bold mb-0">DOB</label>
                                <p className="secondaryText">{user?.date_of_birth}</p>
                              </div>
                              <div className="col-12 my-3">
                                <label className="gilroy bold mb-0">Bio</label>
                                <p className="secondaryText">{user?.about}</p>
                              </div>
                            </div>
                          </div>
                        </>
                      ) : (
                        ""
                      )}
                    </div>
                  </div>
                  <div className="col-md-12 d-flex align-items-center gap-3 flex-wrap">
                    <CustomButton
                      type="button"
                      variant="btnBlueBG"
                      className="px-5"
                      text="Edit Profile"
                      onClick={handleShow}
                    />
                    <CustomButton
                      type="button"
                      className="primaryColor"
                      text="Change Preferences"
                      onClick={handleShow2}
                    />
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
      </UserLayout >
      <CustomModal
        show={showModal}
        close={() => setShowModal(false)}
        success
        heading="For Profile Edit, you have to open the app."
      />
      <CustomModal
        show={showModal2}
        close={() => setShowModal2(false)}
        success
        heading="For change preference, you have to open the app."
      />
    </>
  );
};

export default UserProfile;
