import React, { useState } from 'react';
import { UserLayout } from '../../../Components/user/Layout';
import InnerBanner from '../../../Components/user/InnerBanner/InnerBanner';
import './index.css'
import { images } from '../../../Assets';
import { useNavigate } from 'react-router-dom';
import CustomButton from '../../../Components/CustomButton';

const SafetyFeatures = () => {
    const [activeEvent, setActiveEvent] = useState('safety-1'); // Set initial active event

    const handleClick = (eventId) => {
        setActiveEvent(eventId); // Update the active event state on click
    };
    const navigate = useNavigate();
    return (
        <UserLayout>
            <InnerBanner title={'Safety Features'} className="about-banner about-banner-sm" />
            <section className="about-us py-sm-5 py-4">
                <div className="container">
                    <div className="row">
                        <div className="col-12">
                            <h5 className='secondaryColor p-lg text-center semi-bold'>At Banded, your safety is our priority. That's why we've designed several features <br /> to ensure you feel comfortable and in control while using the app. <br /> Here's how Banded keeps you safe:</h5>
                        </div>
                    </div>
                </div>
            </section>
            <section className="event-trigger">
                <div className="container">
                    <div className="row">
                        <div className="col-12">
                            <div className="event-trigger-wrapper">
                                <a
                                    href="#safety-1"
                                    className={activeEvent === 'safety-1' ? 'current-event active' : 'current-event'}
                                    onClick={() => handleClick('safety-1')}
                                >
                                    <svg width="19" height="20" viewBox="0 0 19 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M16.875 0H1.875C1.37772 0 0.900806 0.197544 0.549175 0.549175C0.197544 0.900806 0 1.37772 0 1.875V7.125C0 12.2147 2.4675 15.3019 4.5375 16.9959C6.76031 18.8137 8.985 19.4334 9.07875 19.4606C9.27276 19.5131 9.47724 19.5131 9.67125 19.4606C9.765 19.4344 11.9897 18.8137 14.2125 16.9959C16.2825 15.3019 18.75 12.2147 18.75 7.125V1.875C18.75 1.37772 18.5525 0.900806 18.2008 0.549175C17.8492 0.197544 17.3723 0 16.875 0ZM16.5 7.125C16.5 10.4728 15.2728 13.1897 12.8522 15.2016C11.8146 16.0577 10.6387 16.7308 9.375 17.1919C8.11117 16.731 6.93523 16.0579 5.89781 15.2016C3.47719 13.1897 2.25 10.4728 2.25 7.125V2.25H16.5V7.125ZM4.82906 10.1709C4.72442 10.0663 4.6414 9.94206 4.58477 9.80533C4.52814 9.6686 4.49899 9.52206 4.49899 9.37406C4.49899 9.22607 4.52814 9.07952 4.58477 8.9428C4.6414 8.80607 4.72442 8.68183 4.82906 8.57719C4.93371 8.47254 5.05794 8.38953 5.19467 8.3329C5.3314 8.27626 5.47794 8.24711 5.62594 8.24711C5.77393 8.24711 5.92048 8.27626 6.0572 8.3329C6.19393 8.38953 6.31817 8.47254 6.42281 8.57719L7.875 10.0312L12.3291 5.57625C12.5404 5.36491 12.8271 5.24617 13.1259 5.24617C13.4248 5.24617 13.7115 5.36491 13.9228 5.57625C14.1342 5.78759 14.2529 6.07424 14.2529 6.37313C14.2529 6.67201 14.1342 6.95866 13.9228 7.17L8.67281 12.42C8.5683 12.5249 8.4441 12.6081 8.30736 12.6649C8.17061 12.7217 8.024 12.7509 7.87594 12.7509C7.72787 12.7509 7.58126 12.7217 7.44452 12.6649C7.30777 12.6081 7.18358 12.5249 7.07906 12.42L4.82906 10.1709Z" fill="#878888" />
                                    </svg>
                                    Safety
                                </a>
                                <a
                                    href="#safety-2"
                                    className={activeEvent === 'safety-2' ? 'current-event active' : 'current-event'}
                                    onClick={() => handleClick('safety-2')}
                                >
                                    <svg width="19" height="19" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M18.75 1.125V4.5C18.75 4.79837 18.6315 5.08452 18.4205 5.2955C18.2095 5.50647 17.9234 5.625 17.625 5.625C17.3266 5.625 17.0405 5.50647 16.8295 5.2955C16.6185 5.08452 16.5 4.79837 16.5 4.5V2.25H14.25C13.9516 2.25 13.6655 2.13147 13.4545 1.9205C13.2435 1.70952 13.125 1.42337 13.125 1.125C13.125 0.826631 13.2435 0.540483 13.4545 0.329505C13.6655 0.118526 13.9516 0 14.25 0H17.625C17.9234 0 18.2095 0.118526 18.4205 0.329505C18.6315 0.540483 18.75 0.826631 18.75 1.125ZM17.625 13.125C17.3266 13.125 17.0405 13.2435 16.8295 13.4545C16.6185 13.6655 16.5 13.9516 16.5 14.25V16.5H14.25C13.9516 16.5 13.6655 16.6185 13.4545 16.8295C13.2435 17.0405 13.125 17.3266 13.125 17.625C13.125 17.9234 13.2435 18.2095 13.4545 18.4205C13.6655 18.6315 13.9516 18.75 14.25 18.75H17.625C17.9234 18.75 18.2095 18.6315 18.4205 18.4205C18.6315 18.2095 18.75 17.9234 18.75 17.625V14.25C18.75 13.9516 18.6315 13.6655 18.4205 13.4545C18.2095 13.2435 17.9234 13.125 17.625 13.125ZM4.5 16.5H2.25V14.25C2.25 13.9516 2.13147 13.6655 1.9205 13.4545C1.70952 13.2435 1.42337 13.125 1.125 13.125C0.826631 13.125 0.540483 13.2435 0.329505 13.4545C0.118526 13.6655 0 13.9516 0 14.25V17.625C0 17.9234 0.118526 18.2095 0.329505 18.4205C0.540483 18.6315 0.826631 18.75 1.125 18.75H4.5C4.79837 18.75 5.08452 18.6315 5.2955 18.4205C5.50647 18.2095 5.625 17.9234 5.625 17.625C5.625 17.3266 5.50647 17.0405 5.2955 16.8295C5.08452 16.6185 4.79837 16.5 4.5 16.5ZM1.125 5.625C1.42337 5.625 1.70952 5.50647 1.9205 5.2955C2.13147 5.08452 2.25 4.79837 2.25 4.5V2.25H4.5C4.79837 2.25 5.08452 2.13147 5.2955 1.9205C5.50647 1.70952 5.625 1.42337 5.625 1.125C5.625 0.826631 5.50647 0.540483 5.2955 0.329505C5.08452 0.118526 4.79837 0 4.5 0H1.125C0.826631 0 0.540483 0.118526 0.329505 0.329505C0.118526 0.540483 0 0.826631 0 1.125V4.5C0 4.79837 0.118526 5.08452 0.329505 5.2955C0.540483 5.50647 0.826631 5.625 1.125 5.625ZM13.875 14.25C13.7004 14.2501 13.5282 14.2096 13.372 14.1316C13.2158 14.0537 13.0799 13.9405 12.975 13.8009C12.5559 13.2417 12.0123 12.7878 11.3872 12.4751C10.7622 12.1625 10.0729 11.9997 9.37406 11.9997C8.6752 11.9997 7.98593 12.1625 7.3609 12.4751C6.73587 12.7878 6.19225 13.2417 5.77313 13.8009C5.59169 14.0333 5.32629 14.1852 5.03403 14.2239C4.74176 14.2626 4.44598 14.185 4.21033 14.0078C3.97468 13.8307 3.818 13.5681 3.77399 13.2766C3.72997 12.985 3.80216 12.6879 3.975 12.4491C4.5717 11.651 5.33747 10.9947 6.2175 10.5272C5.71172 9.92598 5.38816 9.19283 5.28487 8.41399C5.18158 7.63515 5.30285 6.84301 5.63444 6.13075C5.96602 5.41849 6.49411 4.81574 7.1566 4.39339C7.81908 3.97105 8.5884 3.74668 9.37406 3.74668C10.1597 3.74668 10.929 3.97105 11.5915 4.39339C12.254 4.81574 12.7821 5.41849 13.1137 6.13075C13.4453 6.84301 13.5665 7.63515 13.4633 8.41399C13.36 9.19283 13.0364 9.92598 12.5306 10.5272C13.4107 10.9947 14.1764 11.651 14.7731 12.4491C14.8987 12.6161 14.9752 12.8147 14.9942 13.0228C15.0132 13.2309 14.9738 13.4401 14.8806 13.6271C14.7873 13.814 14.6439 13.9713 14.4663 14.0814C14.2887 14.1914 14.0839 14.2498 13.875 14.25ZM9.375 9.75C9.74584 9.75 10.1084 9.64003 10.4167 9.43401C10.725 9.22798 10.9654 8.93514 11.1073 8.59253C11.2492 8.24992 11.2863 7.87292 11.214 7.50921C11.1416 7.14549 10.963 6.8114 10.7008 6.54917C10.4386 6.28695 10.1045 6.10837 9.7408 6.03603C9.37708 5.96368 9.00008 6.00081 8.65747 6.14273C8.31486 6.28464 8.02202 6.52496 7.81599 6.83331C7.60997 7.14165 7.5 7.50416 7.5 7.875C7.5 8.37228 7.69754 8.84919 8.04918 9.20082C8.40081 9.55246 8.87772 9.75 9.375 9.75Z" fill="#878888" />
                                    </svg>
                                    Facial Verification
                                </a>
                                <a
                                    href="#safety-3"
                                    className={activeEvent === 'safety-3' ? 'current-event active' : 'current-event'}
                                    onClick={() => handleClick('safety-3')}
                                >
                                    <svg width="24" height="19" viewBox="0 0 24 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M4.96007 0.37842C4.86127 0.267054 4.74135 0.176404 4.60727 0.111725C4.47318 0.047045 4.32759 0.009622 4.17893 0.00162454C4.03027 -0.00637292 3.88151 0.0152142 3.74125 0.0651348C3.601 0.115055 3.47205 0.192316 3.36188 0.29244C3.2517 0.392564 3.1625 0.513559 3.09943 0.648412C3.03636 0.783266 3.00069 0.929295 2.99447 1.07804C2.98826 1.22678 3.01163 1.37528 3.06323 1.51492C3.11483 1.65457 3.19363 1.78258 3.29507 1.89154L4.79506 3.54623C1.56538 5.69686 0.163815 8.78311 0.0963153 8.92842C0.0328026 9.07242 0 9.22807 0 9.38545C0 9.54283 0.0328026 9.69849 0.0963153 9.84248C0.131003 9.91936 0.952253 11.7419 2.76725 13.5559C5.1935 15.9794 8.25257 17.26 11.6276 17.26C13.2679 17.2691 14.8934 16.9503 16.4088 16.3225L18.2923 18.3944C18.494 18.611 18.7729 18.7395 19.0687 18.7518C19.3645 18.7642 19.6532 18.6595 19.8723 18.4604C20.0914 18.2613 20.2232 17.9839 20.2391 17.6882C20.255 17.3926 20.1537 17.1027 19.9573 16.8812L4.96007 0.37842ZM11.6276 15.01C8.8535 15.01 6.42725 14.004 4.41725 12.0212C3.62662 11.2384 2.9463 10.3515 2.39507 9.38498C2.88913 8.51217 4.15663 6.58186 6.33257 5.23279L14.7785 14.5244C13.7599 14.8496 12.6968 15.0134 11.6276 15.01ZM23.1588 9.84248C23.1251 9.91842 22.3151 11.7175 20.5338 13.5137C20.4318 13.627 20.3079 13.7183 20.1695 13.7821C20.0312 13.846 19.8813 13.8811 19.7289 13.8853C19.5766 13.8895 19.425 13.8627 19.2833 13.8065C19.1417 13.7504 19.0129 13.666 18.9048 13.5586C18.7968 13.4511 18.7116 13.3229 18.6546 13.1815C18.5976 13.0402 18.5699 12.8888 18.5732 12.7364C18.5765 12.5841 18.6107 12.434 18.6738 12.2952C18.7369 12.1565 18.8274 12.032 18.9401 11.9294C19.6883 11.1686 20.3338 10.3132 20.8601 9.38498C20.3092 8.41828 19.6288 7.53133 18.8379 6.74873C16.8269 4.76592 14.4016 3.75998 11.6276 3.75998C11.3135 3.75998 10.9994 3.77311 10.6901 3.79936C10.541 3.81533 10.3902 3.80134 10.2466 3.7582C10.103 3.71507 9.96947 3.64367 9.85386 3.54819C9.73824 3.45271 9.64289 3.33508 9.57338 3.20222C9.50388 3.06936 9.46164 2.92395 9.44914 2.77453C9.43664 2.62511 9.45414 2.47471 9.5006 2.33215C9.54707 2.18959 9.62156 2.05775 9.7197 1.94439C9.81785 1.83104 9.93766 1.73844 10.0721 1.67205C10.2065 1.60566 10.3529 1.56681 10.5026 1.55779C10.871 1.52592 11.2526 1.50998 11.6276 1.50998C15.0026 1.50998 18.0616 2.79154 20.486 5.21498C22.3001 7.02904 23.1213 8.85248 23.156 8.92842C23.22 9.07222 23.2532 9.22777 23.2537 9.38515C23.2542 9.54254 23.2219 9.69829 23.1588 9.84248Z" fill="#878888" />
                                    </svg>
                                    Ghost Mode
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section className="how-it-works-section-3 py-sm-5 py-4" id='safety-1'>
                <div className="container">
                    <div className="row align-items-center">
                        <div className="col-lg-6 my-3">
                            <div style={{ maxWidth: 550 }}>
                                <h4 className="heavy">The Safety Pin: Control Your Location Visibility</h4>
                                <p>With Banded's Safety Pin, you decide when and where your location is visible:</p>
                                <ul>
                                    <li>Pin Your Location: Set a safety pin on the map in areas where you don't want your location automatically shown.</li>
                                    <li>Adjustable Radius: You can increase or decrease the radius around the safety pin to control how large the invisible zone is.</li>
                                    <li>Stay Hidden in Your Safety Zone: While in this zone, your location will remain hidden from other users, giving you peace of mind.</li>
                                </ul>
                                <p>This feature is perfect for situations where you may not want to reveal your location, such as when you're at home or in a specific area you frequent.</p>
                            </div>
                        </div>
                        <div className="col-lg-6 ps-lg-5 my-3 text-center">
                            <img src={images.safetyFeatures1} alt="" className="img-fluid" />
                        </div>
                    </div>
                </div>
            </section>
            <section className="how-it-works-section-2 py-sm-5 py-4" id='safety-2'>
                <div className="container">
                    <div className="row align-items-center">
                        <div className="col-lg-6 pe-lg-5 my-3 order-lg-1 order-2 text-center">
                            <img src={images.safetyFeatures2} alt="" className="img-fluid" />
                        </div>
                        <div className="col-lg-6 my-3 order-lg-2 order-1">
                            <h4 className="heavy">Facial Verification: Authentic Users Only</h4>
                            <p>Banded ensures only real users gain access to our map and location features:</p>
                            <ul>
                                <li>Facial Verification: To use map-based features, users must verify their identity with a facial scan.</li>
                                <li>Secure and Authentic: This added layer of security helps verify the authenticity of users, so you know that the people near you are who they claim to be.</li>
                            </ul>
                            <p>By verifying users through facial recognition, Banded creates a more trustworthy and safe environment for everyone.</p>
                        </div>
                    </div>
                </div>
            </section>
            <section className="how-it-works-section-1 py-sm-5 py-4" id='safety-3'>
                <div className="container">
                    <div className="row align-items-center">
                        <div className="col-lg-6 my-3">
                            <h4 className="heavy">Ghost Mode: Stay Private at Any Time</h4>
                            <p>Sometimes, you just want to go off the radar. Ghost Mode lets you do exactly that:</p>
                            <ul>
                                <li>Turn Off Your Location: Quickly toggle Ghost Mode to hide your location from the map.</li>
                                <li>Mutual Restrictions: When Ghost Mode is enabled, you won't be able to see others on the map either, keeping things fair.</li>
                                <li>Instant Privacy: This feature gives you full control of when and where your location is visible, helping you stay in control of your privacy at all times.</li>
                            </ul>
                            <p>Whether you need a quick break or just don't want to be found, Ghost Mode gives you the power to step away whenever you need.</p>
                        </div>
                        <div className="col-lg-6 ps-lg-5 my-3 text-center">
                            <img src={images.safetyFeatures3} alt="" className="img-fluid" />
                        </div>
                    </div>
                </div>
            </section>
            <section className="join-our-community pb-sm-5 pb-4">
                <div className="container">
                    <div className="row">
                        <div className="col-12">
                            <div className="join-our-community-inner py-sm-5">
                                <h4 className="heavy">Your Safety, Your Control</h4>
                                <p className='my-4'>Banded believes in putting the power in your hands. Whether it's using the Safety Pin to control your visibility, verifying <br /> users with facial recognition, or activating Ghost Mode for complete privacy, our features are designed to keep you safe, <br /> secure, and in control of your experience.</p>
                                <CustomButton onClick={()=> navigate('/register')} text="Join Today" className="yellow-btn px-5" />
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        </UserLayout>
    );
}

export default SafetyFeatures;
