import { useNavigate, useParams, useLocation } from "react-router";
import CustomButton from "../../../Components/CustomButton";
import { UserLayout } from "../../../Components/user/Layout";
import BackButton from "../../../Components/BackButton";
import { useEffect, useState } from "react";
import { connectedProfiles, newRequest, profiles } from "../../../Config/userData";
import './index.css'
import CustomModal from "../../../Components/CustomModal";
import { getDetails } from "../../../Services/Api";
import { images } from "../../../Assets";

const ViewProfileDetails = () => {
  const navigate = useNavigate();
  const { id } = useParams();
  const location = useLocation();
  const [userDetails, setUserDetails] = useState({});
  const [details, setDetails] = useState({});
  const [connectProfile, setConnectProfile] = useState(false);
  const getUser = async () => {
    const response = await getDetails(`/user/profileWithDetails/${id}`);
    if (response.status) {
      setUserDetails(response.data);
    }
  };
  useEffect(() => {
    getUser();
    if (location.pathname.includes('request')) {
      let profile = newRequest.find(item => item.id == 1);
      setDetails(profile);
    } else if (location.pathname.includes('connected')) {
      let profile = connectedProfiles.find(item => item.id == 1);
      setDetails(profile);
      setConnectProfile(true)
    } else {
      let profile = profiles.find(item => item.id == 1);
      setDetails(profile);
    }

  }, [id, location]);
  const [show, setShow] = useState(false);
  const handleShow = async () => {
    let response = await getDetails(`/user/friends/unFriend/${id}`);
    if (response.status) {
      setShow2(true)
    }
    setShow(true)
  };
  const handleClose = () => {
    setShow(false);
  }
  const action = () => {
    setShow(false)
    setShow2(true);
  }
  const [show2, setShow2] = useState(false);
  const handleClose2 = () => {
    setShow2(false);
    navigate('/connected-users');
  }
  return (
    <>
      <UserLayout pageTitle="User Profile">
        <div className="profile-bg py-sm-5 py-4">
          <div className="container">
            <div className="row">
              <div className="col-12">
                <div className="contact-card mxw-100 px-sm-5">
                  <div className="row mb-3">
                    <div className="col-12">
                      <div className="d-flex align-items-center gap-2">
                        <BackButton />
                        <h4 className="heavy mb-0">User Profile</h4>
                      </div>
                    </div>
                  </div>
                  <div className="row mb-3">
                    <div className="col-12">
                      <div className="row mb-3">
                        <div className="col-lg-12 order-2 order-lg-1 mb-3">
                          <div className="profileImage">
                            <img src={userDetails?.image_url ? userDetails?.image_url : images.noImageFound} alt="User" />
                          </div>
                        </div>
                      </div>
                      <div className="row">
                        <div className="col-12">
                          <div className="top-profile-view-card">
                            <label className="gilroy bold mb-0">Basic Information</label>
                            <p className="mb-0">{userDetails?.about}</p>
                            <div className="row">
                              {userDetails?.preferences?.map((field, index) => (
                                <div className="col-md-4 col-sm-6 col-12 my-3" key={index}>
                                  <label className="gilroy bold mb-0">{field.question_text}</label>
                                  {field?.answers?.map((answer, index) => (
                                    <div key={index}>
                                      <p className="mb-0">{answer?.option_text}</p>
                                    </div>
                                  ))}

                                </div>
                              ))}

                              {userDetails?.user_answers?.map((field, index) => (
                                <div className="col-md-4 col-sm-6 col-12 my-3" key={index}>
                                  <label className="gilroy bold mb-0">Q : {field?.question?.question_text}</label>

                                  <p className="mb-0">{field?.answer}</p>
                                </div>
                              ))}

                            </div>
                            <div className="mt-3 d-flex align-items-center gap-3 flex-wrap">
                              {userDetails?.images?.map((item, index) => (
                                <img src={item?.path} key={index} alt="" className="img-fluid profile-detail-img" />
                              ))}
                            </div>
                            {connectProfile && (
                              <div className="mt-lg-5 mt-4">
                                <CustomButton text="Remove" onClick={handleShow} className="px-5" />
                              </div>
                            )}
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
      </UserLayout >
      <CustomModal
        show={show}
        action={action}
        close={handleClose}
        heading="Are you sure you want to remove this User?"
      />
      <CustomModal
        show={show2}
        close={handleClose2}
        success
        heading="User has been removed successfully!"
      />
    </>
  );
};

export default ViewProfileDetails;
