import { useNavigate, useParams, useLocation } from "react-router";
import CustomButton from "../../../Components/CustomButton";
import { UserLayout } from "../../../Components/user/Layout";
import BackButton from "../../../Components/BackButton";
import { useEffect, useState } from "react";
import { newRequest, profiles } from "../../../Config/userData";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faStar } from "@fortawesome/free-solid-svg-icons";
import { images } from "../../../Assets";
import CustomModal from "../../../Components/CustomModal";
import { getDetails, post } from "../../../Services/Api";

const TopProfileView = () => {
  const navigate = useNavigate();
  const { id } = useParams();
  const location = useLocation();
  const queryParams = new URLSearchParams(location.search);
  const request_id = queryParams.get("request_id");
  const [details, setDetails] = useState({});
  const [requestPage, setRequestPage] = useState(false);
  const [userDetails, setUserDetails] = useState({});
  const getUser = async () => {
    const response = await getDetails(`/user/profile/${id}`);
    if (response.status) {
      setUserDetails(response.data);
    }
  };
  useEffect(() => {
    getUser();
    if (location.pathname.includes('request')) {
      let profile = newRequest.find(item => item.id == id);
      setDetails(profile);
      setRequestPage(true);
    } else {
      let profile = profiles.find(item => item.id == id);
      setDetails(profile);
    }

  }, [id, location]);

  const [show, setShow] = useState(false);
  const handleShow = async () => {
    let response = await post(`/user/friends/accept/${request_id}`);
    if (response.status) {
      setShow(true)
    }
  };
  const handleClose = () => {
    setShow(false);
    navigate('/new-requests');
  }
  const [show2, setShow2] = useState(false);
  const handleShow2 = async () => {
    let response = await post(`/user/friends/reject/${request_id}`);
    if (response.status) {
      setShow2(true)
    }
  };
  const handleClose2 = () => {
    setShow2(false);
    navigate('/new-requests');
  }
  return (
    <>
      <UserLayout pageTitle="View Profile">
        <div className="profile-bg py-sm-5 py-4">
          <div className="container">
            <div className="row">
              <div className="col-12">
                <div className="contact-card mxw-100 px-sm-5">
                  <div className="row mb-3">
                    <div className="col-12">
                      <div className="d-flex align-items-center gap-3 flex-wrap-reverse justify-content-between">
                        <div className="d-flex align-items-center gap-2">
                          <BackButton />
                          <h4 className="heavy mb-0">View Profile</h4>
                        </div>
                        {details?.top && (
                          <div>
                            <h3 className="text-end"><FontAwesomeIcon icon={faStar} className="yellowColor" /></h3>
                            {requestPage && (
                              <CustomButton
                                type="button"
                                variant="btnBlueBG"
                                className="px-5"
                                text="View Profile"
                                onClick={() => {
                                  navigate(`/view-request-profile-details/${id}`);
                                }}
                              />
                            )}
                          </div>
                        )}
                      </div>
                    </div>
                  </div>
                  <div className="row mb-3">
                    <div className="col-12">
                      <div className="row mb-3">
                        <div className="col-lg-12 order-2 order-lg-1 mb-3">
                          <div className="profileImage">
                            <img src={userDetails?.image_url ? userDetails?.image_url : images.noImageFound} alt="User" />
                          </div>
                        </div>
                      </div>
                      <div className="row">
                        <div className="col-lg-8">
                          <div className="row mb-4">
                            <div className="col-12 mb-3">
                              <div className="d-flex gap-sm-5 gap-4">
                                <div>
                                  <label className="gilroy bold mb-0">Name</label>
                                  <p className="secondaryText">{userDetails?.full_name}</p>
                                </div>
                                <div>
                                  <label className="gilroy bold mb-0">Age</label>
                                  <p className="secondaryText">{userDetails?.age}</p>
                                </div>
                                {userDetails?.ring && (
                                  <div>
                                    <label className="gilroy d-block bold mb-0">Band Color</label>
                                    <p className="secondaryText">{userDetails?.ring?.toUpperCase()}</p>

                                    {/* <img src={images.userRing} alt="" className="img-fluid" /> */}
                                  </div>
                                )}
                              </div>
                              <p className="mb-0">{userDetails?.about}</p>
                            </div>
                          </div>
                        </div>
                        <div className="col-12">
                          {requestPage ? (
                            <div className="d-flex align-items-center gap-3 flex-wrap">
                              <CustomButton onClick={handleShow2} className="yellow-btn px-5" text="Reject" />
                              <CustomButton onClick={handleShow} text="Accept" className="px-5" />
                            </div>
                          ) : (
                            <CustomButton
                              type="button"
                              variant="btnBlueBG"
                              className="px-5"
                              text="View Profile"
                              onClick={() => {
                                navigate(`/view-profile-details/${id}`);
                              }}
                            />
                          )}
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
      </UserLayout>
      <CustomModal
        show={show}
        close={handleClose}
        success
        heading="Request accepted successfully!"
      />
      <CustomModal
        show={show2}
        close={handleClose2}
        success
        heading="Request rejected successfully!"
      />
    </>
  );
};

export default TopProfileView;
