import { Navigate, Outlet } from "react-router-dom";
import { useAuth } from "../Hooks/useAuth";

const ProtectedRoutes = (props) => {
  const { role, token } = useAuth();
  if (token) {
    if (props?.roles?.includes(role)) {
      return <Outlet />;
    } else {
      return <Navigate to={"/"} />;
    }
  } else if (props?.admin) {
    return <Navigate to="/admin/" />;
  } else if (props?.user) {
    console.log('ProtectedRoutes')
    return <Navigate to="/login" />;
  } else {
    return <Navigate to="/admin/login" />;
  }
};

export default ProtectedRoutes;
