import { useRoutes } from "react-router-dom";

/* Admin Routes */

import { Dashboard } from "../Pages/Admin/Dashboard";
import ForgetPassword from "../Pages/Admin/Auth/ForgetPassword";
import ForgetPassword2 from "../Pages/Admin/Auth/ForgetPassword2";
import ForgetPassword3 from "../Pages/Admin/Auth/ForgetPassword3";
import AdminLogin from "../Pages/Admin/Auth/Login";
import GuestRoutes from "./GuestRoutes";
import PreventAdmin from "./PreventAdmin";
import ProtectedRoutes from "./ProtectedRoutes";
import Profile from "../Pages/Admin/Profile";
import EditProfile from "../Pages/Admin/Profile/EditProfile";
import ChangePassword from "../Pages/Admin/Profile/ChangePassword";
import UserManagement from "../Pages/Admin/UserManagement";
import UserDetails from "../Pages/Admin/UserManagement/UserDetails";
import FeedbacksManagement from "../Pages/Admin/FeedbacksManagement";
import FeedbackDetails from "../Pages/Admin/FeedbacksManagement/FeedbackDetails";
import NotificationsAdmin from "../Pages/Admin/Notifications";

import QueryManagement from "../Pages/Admin/QueryManagement";
import QueryDetails from "../Pages/Admin/QueryManagement/QueryDetails";
import ReportManagement from "../Pages/Admin/ReportManagement";
import ReportDetails from "../Pages/Admin/ReportManagement/ReportDetails";
import BannerManagement from "../Pages/Admin/BannerManagement";
import BannerDetails from "../Pages/Admin/BannerManagement/BannerDetails";
import AddBanner from "../Pages/Admin/BannerManagement/AddBanner";
import EditBanner from "../Pages/Admin/BannerManagement/EditBanner";
import CategoryManagement from "../Pages/Admin/CategoryManagement";
import AddCategory from "../Pages/Admin/CategoryManagement/AddCategory";
import CategoryDetails from "../Pages/Admin/CategoryManagement/CategoryDetails";
import EditCategory from "../Pages/Admin/CategoryManagement/EditCategory";
import ProductManagement from "../Pages/Admin/ProductManagement";
import ProductDetails from "../Pages/Admin/ProductManagement/ProductDetails";
import AddProduct from "../Pages/Admin/ProductManagement/AddProduct";
import EditProduct from "../Pages/Admin/ProductManagement/EditProduct";
import OrderManagement from "../Pages/Admin/OrderManagement";
import OrderDetails from "../Pages/Admin/OrderManagement/OrderDetails";
import DeliveryChargesManagement from "../Pages/Admin/DeliveryChargesManagement";
import PaymentLogs from "../Pages/Admin/PaymentLogs";
import Home from "../Pages/User/Home";
import AboutUs from "../Pages/User/AboutUs";
import ContactUs from "../Pages/User/ContactUs";
import Login from "../Pages/User/Auth/Login";
import UserProfile from "../Pages/User/Profile";
import UserChangePassword from "../Pages/User/Profile/ChangePassword";
import UserNotifications from "../Pages/User/Notifications";
import UserForgetPassword from "../Pages/User/Auth/ForgetPassword";
import UserForgetPassword2 from "../Pages/User/Auth/ForgetPassword2";
import UserForgetPassword3 from "../Pages/User/Auth/ForgetPassword3";
import Register from "../Pages/User/Auth/Register";
import TopProfileView from "../Pages/User/TopProfileView";
import ViewProfileDetails from "../Pages/User/TopProfileView/ViewProfileDetails";
import ViewProfileDetailsUnauthenticated from "../Pages/User/TopProfileView/ViewProfileDetailsUnauthenticated";
import NewRequests from "../Pages/User/NewRequests";
import ConnectedUsers from "../Pages/User/ConnectedUsers";
import Products from "../Pages/User/Products";
import UserProductDetails from "../Pages/User/Products/ProductDetails";
import MyCart from "../Pages/User/Cart";
import Checkout from "../Pages/User/Checkout";
import BankDetails from "../Pages/User/BankDetails";
import MyOrders from "../Pages/User/OrderManagement";
import UserOrderDetails from "../Pages/User/OrderManagement/OrderDetails";
import Wishlist from "../Pages/User/Wishlist";
import InteractWithHappiness from "../Pages/User/InteractWithHappiness";
import ViewInteractProfileDetails from "../Pages/User/InteractWithHappiness/ViewProfileDetails";
import Policies from "../Pages/User/Policies";
import HowItWorks from "../Pages/User/HowItWorks";
import SafetyFeatures from "../Pages/User/SafetyFeatures";
import FAQs from "../Pages/User/FAQs";
import Categories from "../Pages/User/Categories";
import EventManagement from "../Pages/Admin/EventManagement";
import AddEvent from "../Pages/Admin/EventManagement/AddEvent";
import EventDetails from "../Pages/Admin/EventManagement/EventDetails";
import EditEvent from "../Pages/Admin/EventManagement/EditEvent";

const roles = {
  admin: "admin",
  user: "user",
};

const routes = [
  {
    path: "/",
    element: "",
    children: [
      { path: "/", element: <Home /> },
      { path: "/about-us", element: <AboutUs /> },
      { path: "/contact-us", element: <ContactUs /> },
      { path: "/bands/:id", element: <Products /> },
      { path: "/product-details/:id", element: <UserProductDetails /> },
      { path: "/cart", element: <MyCart /> },
      { path: "/categories", element: <Categories /> },
      { path: "/policies", element: <Policies /> },
      { path: "/how-it-works", element: <HowItWorks /> },
      { path: "/safety-features", element: <SafetyFeatures /> },
      { path: "/faqs", element: <FAQs /> },
      { path: "/view-profile-nfc-details/:id", element: <ViewProfileDetailsUnauthenticated /> },
      { path: "/checkout", element: <Checkout /> },

      {
        element: <GuestRoutes admin />,
        children: [
          { path: "admin", element: <AdminLogin /> },
          { path: "admin/login", element: <AdminLogin /> },
          { path: "admin/forget-password", element: <ForgetPassword /> },
          { path: "admin/forget-password2", element: <ForgetPassword2 /> },
          { path: "admin/forget-password3", element: <ForgetPassword3 /> },
          { path: "admin/*", element: <PreventAdmin /> },
        ],
      },
      {
        element: <ProtectedRoutes admin roles={[roles.admin]} />,
        children: [
          { path: "admin/*", element: <PreventAdmin /> },
          { path: "admin/dashboard", element: <Dashboard /> },
          { path: "admin/profile", element: <Profile /> },
          { path: "admin/edit-profile", element: <EditProfile /> },
          { path: "admin/change-password", element: <ChangePassword /> },
          { path: "admin/user-management", element: <UserManagement /> },
          { path: "admin/user-management/:id", element: <UserDetails /> },
          { path: "admin/query-management", element: <QueryManagement /> },
          { path: "admin/query-management/details/:id", element: <QueryDetails /> },
          { path: "admin/report-management", element: <ReportManagement /> },
          { path: "admin/report-management/details/:id", element: <ReportDetails /> },
          { path: "admin/banner-management", element: <BannerManagement /> },
          { path: "admin/banner-management/details/:id", element: <BannerDetails /> },
          { path: "admin/banner-management/add", element: <AddBanner /> },
          { path: "admin/banner-management/edit/:id", element: <EditBanner /> },
          { path: "admin/event-management", element: <EventManagement /> },
          { path: "admin/event-management/add", element: <AddEvent /> },
          { path: "admin/event-management/details/:id", element: <EventDetails /> },
          { path: "admin/event-management/edit/:id", element: <EditEvent /> },
          { path: "admin/category-management", element: <CategoryManagement /> },
          { path: "admin/category-management/add", element: <AddCategory /> },
          { path: "admin/category-management/details/:id", element: <CategoryDetails /> },
          { path: "admin/category-management/edit/:id", element: <EditCategory /> },
          { path: "admin/product-management", element: <ProductManagement /> },
          { path: "admin/product-management/add", element: <AddProduct /> },
          { path: "admin/product-management/details/:id", element: <ProductDetails /> },
          { path: "admin/product-management/edit/:id", element: <EditProduct /> },
          { path: "admin/order-management", element: <OrderManagement /> },
          { path: "admin/order-management/details/:id", element: <OrderDetails /> },
          { path: "admin/delivery-charges-management", element: <DeliveryChargesManagement /> },
          { path: "admin/payment-logs", element: <PaymentLogs /> },

          {
            path: "admin/feedbacks-management",
            element: <FeedbacksManagement />,
          },
          {
            path: "admin/feedbacks-management/:id",
            element: <FeedbackDetails />,
          },
          { path: "admin/notifications", element: <NotificationsAdmin /> },
        ],
      },
      {
        element: <GuestRoutes user />,
        children: [
          { path: "/login", element: <Login /> },
          { path: "/forget-password", element: <UserForgetPassword /> },
          { path: "/forget-password2", element: <UserForgetPassword2 /> },
          { path: "/forget-password3", element: <UserForgetPassword3 /> },
          { path: "/register", element: <Register /> },



          // { path: "/*", element: <PreventUser /> },
        ],
      },
      {
        element: <ProtectedRoutes user roles={[roles.user]} />,
        children: [
          { path: "/profile", element: <UserProfile /> },
          { path: "/change-password", element: <UserChangePassword /> },
          { path: "/notifications", element: <UserNotifications /> },
          { path: "/top-profile-view/:id", element: <TopProfileView /> },
          { path: "/view-profile-details/:id", element: <ViewProfileDetails /> },
          { path: "/new-requests", element: <NewRequests /> },
          { path: "/request-profile-view/:id", element: <TopProfileView /> },
          { path: "/view-request-profile-details/:id", element: <ViewProfileDetails /> },
          { path: "/connected-users", element: <ConnectedUsers /> },
          { path: "/view-connected-profile-details/:id", element: <ViewProfileDetails /> },
          { path: "/bank-details", element: <BankDetails /> },
          { path: "/my-orders", element: <MyOrders /> },
          { path: "/order-details/:id", element: <UserOrderDetails /> },
          { path: "/wishlist", element: <Wishlist /> },
          { path: "/find-new-match", element: <InteractWithHappiness /> },
          { path: "/view-interact-profile-details/:id", element: <ViewInteractProfileDetails /> },

          // { path: "/*", element: <PreventUser /> },
        ],
      },
    ],
  },
];

const Routers = () => {
  const element = useRoutes(routes);
  return element;
};

export default Routers;
