import { useDispatch } from "react-redux";
import axios from "axios";
import { buildFormData } from "../Utils/helper";
import {
  setData,
  setRoles,
  setToken,
  logout as logoutAction,
} from "../Store/actions";

import { getAll, logout } from "./Api";
import { showToast } from "../Components/Toast";
import { addMultipleToCart, clearCart } from "../Store/actions/cartActions";
import { useAuth } from '../Hooks/useAuth';

export const useLogin = () => {
  const dispatch = useDispatch();
  const login = async (route, params = {}) => {
    try {
      const fd = new FormData();
      buildFormData(fd, params);
      let response = await axios.post(route, fd);
      response = response?.data;
      // Update Redux state
      dispatch(setToken(response?.data?.token));
      dispatch(setRoles(response?.data?.user?.type));
      dispatch(setData(response?.data?.user));
      const responseCart = await getAll(`/user/cart/items?user_id=${response?.data?.user?.id}`);
      if (responseCart.status) {
        dispatch(clearCart());
        const productIds = responseCart?.data.map(item => ({ id: item.product.id }));
        console.log("api response", productIds);
        dispatch(addMultipleToCart(productIds))
      }

    } catch (error) {
      showToast(error?.response?.data?.data?.message?.failed, "error");
      return false;
      // console.log('Error:', error.response ? error.response.data : error.message);
      // return error.response ? error.response.data : { message: 'Unknown error occurred' };
    }
  };

  return login;
};

export const useLogout = () => {
  const dispatch = useDispatch();
  const { user, sessionId } = useAuth();

  const handleLogout = async (role) => {
    try {
      await logout(`/${role}/logout`);

      setTimeout(() => {
        localStorage.clear();
        dispatch(logoutAction());
        dispatch(setToken());
        dispatch(setRoles());
        dispatch(setData());
      }, 1000);
      dispatch(clearCart());
      const responseCart = await getAll(`/user/cart/items?user_id=${sessionId.sessionId}`);
      if (responseCart.status) {
        const productIds = responseCart?.data.map(item => ({ id: item.product.id }));
        console.log("api response", productIds);
        dispatch(addMultipleToCart(productIds))
      }
    } catch (error) {
      console.error("Logout failed", error);
    }
  };

  return handleLogout;
};
