import { ADD_TO_CART, ADD_MULTIPLE_TO_CART, REMOVE_FROM_CART, CLEAR_CART } from '../actions/cartActions';

const initialState = {
    items: [],
};

const cartReducer = (state = initialState, action) => {
    switch (action.type) {
        case ADD_TO_CART:
            console.log("cart ADD_TO_CART");

            // Check if the product is already in the cart
            const existingProduct = state.items.find(item => item.id === action.payload.id);
            if (existingProduct) {
                return {
                    ...state,
                    items: state.items.map(item =>
                        item.id === action.payload.id
                            ? { ...item, quantity: item.quantity + 1 } // Increment quantity if it exists
                            : item
                    ),
                };
            }
            // If product doesn't exist, add it with quantity 1
            return {
                ...state,
                items: [...state.items, { ...action.payload, quantity: 1 }],
            };

        case ADD_MULTIPLE_TO_CART:
            console.log("cart ADD_MULTIPLE_TO_CART");

            // Handle adding multiple products to the cart
            return {
                ...state,
                items: state.items.concat(
                    action.payload.map(product => {
                        const existingProduct = state.items.find(item => item.id === product.id);
                        if (existingProduct) {
                            return { ...existingProduct, quantity: existingProduct.quantity + 1 };
                        }
                        return { ...product, quantity: 1 };
                    })
                ),
            };

        case REMOVE_FROM_CART:
            // Remove the product from the cart by id
            return {
                ...state,
                items: state.items.filter(item => item.id !== action.payload?.productId),
            };

        case CLEAR_CART:
            console.log("cart clear");

            // Clear the entire cart
            return initialState;

        default:
            return state;
    }
};

export default cartReducer;
