import { combineReducers } from "redux";
import setDataReducer from "./setDataReducer";
import resetDataReducer from "./resetDataReducer";
import imagesReducer from "./imagesReducer";
import tokenReducer from "./tokenReducer";
import sessionReducer from "./sessionReducer";
import roleReducer from "./roleReducer";
import logoutReducer from "./logoutReducer";
import cartReducer from "./cartReducer";

const rootReducer = combineReducers({
  data: setDataReducer,
  reset: resetDataReducer,
  image: imagesReducer,
  token: tokenReducer,
  sessionId: sessionReducer,
  role: roleReducer,
  logout: logoutReducer, // Add the logout reducer here
  cart: cartReducer,
});

export default rootReducer;
