// Define a function to generate a session ID (BigInt)
const generateSessionId = () => {
    // Generate a random number between 0 and 1e18 (exclusive), return it as a number
    return Math.floor(Math.random() * 1e18); // This returns a regular number
};

// Check if a session ID exists in localStorage
let storedSessionId = localStorage.getItem('sessionId');

if (!storedSessionId) {
    // If no session ID exists, generate a new one and store it in localStorage
    storedSessionId = generateSessionId();
    localStorage.setItem('sessionId', storedSessionId.toString()); // Store the session ID as string in localStorage
}

// Initial Redux state
const initialState = {
    sessionId: storedSessionId, // Ensure the session ID is stored as BigInt
};

// Reducer to handle session-related actions
const sessionReducer = (state = initialState, action) => {
    switch (action.type) {
        case 'SET_SESSION_ID':  // Action type is renamed to 'SET_SESSION_ID' for clarity
            return {
                ...state,
                sessionId: action.payload, // Update sessionId in state
            };
        default:
            return state;
    }
};

export default sessionReducer;